/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2clientvpn;

import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EndpointArgs
extends ResourceArgs {
    public static final EndpointArgs Empty = new EndpointArgs();
    @Import(name="authenticationOptions", required=true)
    private Output<List<EndpointAuthenticationOptionArgs>> authenticationOptions;
    @Import(name="clientCidrBlock", required=true)
    private Output<String> clientCidrBlock;
    @Import(name="clientConnectOptions")
    @Nullable
    private Output<EndpointClientConnectOptionsArgs> clientConnectOptions;
    @Import(name="clientLoginBannerOptions")
    @Nullable
    private Output<EndpointClientLoginBannerOptionsArgs> clientLoginBannerOptions;
    @Import(name="connectionLogOptions", required=true)
    private Output<EndpointConnectionLogOptionsArgs> connectionLogOptions;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="dnsServers")
    @Nullable
    private Output<List<String>> dnsServers;
    @Import(name="securityGroupIds")
    @Nullable
    private Output<List<String>> securityGroupIds;
    @Import(name="selfServicePortal")
    @Nullable
    private Output<String> selfServicePortal;
    @Import(name="serverCertificateArn", required=true)
    private Output<String> serverCertificateArn;
    @Import(name="sessionTimeoutHours")
    @Nullable
    private Output<Integer> sessionTimeoutHours;
    @Import(name="splitTunnel")
    @Nullable
    private Output<Boolean> splitTunnel;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="transportProtocol")
    @Nullable
    private Output<String> transportProtocol;
    @Import(name="vpcId")
    @Nullable
    private Output<String> vpcId;
    @Import(name="vpnPort")
    @Nullable
    private Output<Integer> vpnPort;

    public Output<List<EndpointAuthenticationOptionArgs>> authenticationOptions() {
        return this.authenticationOptions;
    }

    public Output<String> clientCidrBlock() {
        return this.clientCidrBlock;
    }

    public Optional<Output<EndpointClientConnectOptionsArgs>> clientConnectOptions() {
        return Optional.ofNullable(this.clientConnectOptions);
    }

    public Optional<Output<EndpointClientLoginBannerOptionsArgs>> clientLoginBannerOptions() {
        return Optional.ofNullable(this.clientLoginBannerOptions);
    }

    public Output<EndpointConnectionLogOptionsArgs> connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Output<List<String>>> dnsServers() {
        return Optional.ofNullable(this.dnsServers);
    }

    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    public Optional<Output<String>> selfServicePortal() {
        return Optional.ofNullable(this.selfServicePortal);
    }

    public Output<String> serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public Optional<Output<Integer>> sessionTimeoutHours() {
        return Optional.ofNullable(this.sessionTimeoutHours);
    }

    public Optional<Output<Boolean>> splitTunnel() {
        return Optional.ofNullable(this.splitTunnel);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Optional<Output<String>> transportProtocol() {
        return Optional.ofNullable(this.transportProtocol);
    }

    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    public Optional<Output<Integer>> vpnPort() {
        return Optional.ofNullable(this.vpnPort);
    }

    private EndpointArgs() {
    }

    private EndpointArgs(EndpointArgs $) {
        this.authenticationOptions = $.authenticationOptions;
        this.clientCidrBlock = $.clientCidrBlock;
        this.clientConnectOptions = $.clientConnectOptions;
        this.clientLoginBannerOptions = $.clientLoginBannerOptions;
        this.connectionLogOptions = $.connectionLogOptions;
        this.description = $.description;
        this.dnsServers = $.dnsServers;
        this.securityGroupIds = $.securityGroupIds;
        this.selfServicePortal = $.selfServicePortal;
        this.serverCertificateArn = $.serverCertificateArn;
        this.sessionTimeoutHours = $.sessionTimeoutHours;
        this.splitTunnel = $.splitTunnel;
        this.tags = $.tags;
        this.transportProtocol = $.transportProtocol;
        this.vpcId = $.vpcId;
        this.vpnPort = $.vpnPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointArgs $;

        public Builder() {
            this.$ = new EndpointArgs();
        }

        public Builder(EndpointArgs defaults) {
            this.$ = new EndpointArgs(Objects.requireNonNull(defaults));
        }

        public Builder authenticationOptions(Output<List<EndpointAuthenticationOptionArgs>> authenticationOptions) {
            this.$.authenticationOptions = authenticationOptions;
            return this;
        }

        public Builder authenticationOptions(List<EndpointAuthenticationOptionArgs> authenticationOptions) {
            return this.authenticationOptions((Output<List<EndpointAuthenticationOptionArgs>>)Output.of(authenticationOptions));
        }

        public Builder authenticationOptions(EndpointAuthenticationOptionArgs ... authenticationOptions) {
            return this.authenticationOptions(List.of(authenticationOptions));
        }

        public Builder clientCidrBlock(Output<String> clientCidrBlock) {
            this.$.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public Builder clientCidrBlock(String clientCidrBlock) {
            return this.clientCidrBlock((Output<String>)Output.of((Object)clientCidrBlock));
        }

        public Builder clientConnectOptions(@Nullable Output<EndpointClientConnectOptionsArgs> clientConnectOptions) {
            this.$.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public Builder clientConnectOptions(EndpointClientConnectOptionsArgs clientConnectOptions) {
            return this.clientConnectOptions((Output<EndpointClientConnectOptionsArgs>)Output.of((Object)((Object)clientConnectOptions)));
        }

        public Builder clientLoginBannerOptions(@Nullable Output<EndpointClientLoginBannerOptionsArgs> clientLoginBannerOptions) {
            this.$.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        public Builder clientLoginBannerOptions(EndpointClientLoginBannerOptionsArgs clientLoginBannerOptions) {
            return this.clientLoginBannerOptions((Output<EndpointClientLoginBannerOptionsArgs>)Output.of((Object)((Object)clientLoginBannerOptions)));
        }

        public Builder connectionLogOptions(Output<EndpointConnectionLogOptionsArgs> connectionLogOptions) {
            this.$.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public Builder connectionLogOptions(EndpointConnectionLogOptionsArgs connectionLogOptions) {
            return this.connectionLogOptions((Output<EndpointConnectionLogOptionsArgs>)Output.of((Object)((Object)connectionLogOptions)));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder dnsServers(@Nullable Output<List<String>> dnsServers) {
            this.$.dnsServers = dnsServers;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            return this.dnsServers((Output<List<String>>)Output.of(dnsServers));
        }

        public Builder dnsServers(String ... dnsServers) {
            return this.dnsServers(List.of(dnsServers));
        }

        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            this.$.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            return this.securityGroupIds((Output<List<String>>)Output.of(securityGroupIds));
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        public Builder selfServicePortal(@Nullable Output<String> selfServicePortal) {
            this.$.selfServicePortal = selfServicePortal;
            return this;
        }

        public Builder selfServicePortal(String selfServicePortal) {
            return this.selfServicePortal((Output<String>)Output.of((Object)selfServicePortal));
        }

        public Builder serverCertificateArn(Output<String> serverCertificateArn) {
            this.$.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            return this.serverCertificateArn((Output<String>)Output.of((Object)serverCertificateArn));
        }

        public Builder sessionTimeoutHours(@Nullable Output<Integer> sessionTimeoutHours) {
            this.$.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            return this.sessionTimeoutHours((Output<Integer>)Output.of((Object)sessionTimeoutHours));
        }

        public Builder splitTunnel(@Nullable Output<Boolean> splitTunnel) {
            this.$.splitTunnel = splitTunnel;
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            return this.splitTunnel((Output<Boolean>)Output.of((Object)splitTunnel));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder transportProtocol(@Nullable Output<String> transportProtocol) {
            this.$.transportProtocol = transportProtocol;
            return this;
        }

        public Builder transportProtocol(String transportProtocol) {
            return this.transportProtocol((Output<String>)Output.of((Object)transportProtocol));
        }

        public Builder vpcId(@Nullable Output<String> vpcId) {
            this.$.vpcId = vpcId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            return this.vpcId((Output<String>)Output.of((Object)vpcId));
        }

        public Builder vpnPort(@Nullable Output<Integer> vpnPort) {
            this.$.vpnPort = vpnPort;
            return this;
        }

        public Builder vpnPort(Integer vpnPort) {
            return this.vpnPort((Output<Integer>)Output.of((Object)vpnPort));
        }

        public EndpointArgs build() {
            this.$.authenticationOptions = Objects.requireNonNull(this.$.authenticationOptions, "expected parameter 'authenticationOptions' to be non-null");
            this.$.clientCidrBlock = Objects.requireNonNull(this.$.clientCidrBlock, "expected parameter 'clientCidrBlock' to be non-null");
            this.$.connectionLogOptions = Objects.requireNonNull(this.$.connectionLogOptions, "expected parameter 'connectionLogOptions' to be non-null");
            this.$.serverCertificateArn = Objects.requireNonNull(this.$.serverCertificateArn, "expected parameter 'serverCertificateArn' to be non-null");
            return this.$;
        }
    }
}

