/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LaunchConfigurationMetadataOptions {
    @Nullable
    private String httpEndpoint;
    @Nullable
    private Integer httpPutResponseHopLimit;
    @Nullable
    private String httpTokens;

    private LaunchConfigurationMetadataOptions() {
    }

    public Optional<String> httpEndpoint() {
        return Optional.ofNullable(this.httpEndpoint);
    }

    public Optional<Integer> httpPutResponseHopLimit() {
        return Optional.ofNullable(this.httpPutResponseHopLimit);
    }

    public Optional<String> httpTokens() {
        return Optional.ofNullable(this.httpTokens);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LaunchConfigurationMetadataOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String httpEndpoint;
        @Nullable
        private Integer httpPutResponseHopLimit;
        @Nullable
        private String httpTokens;

        public Builder() {
        }

        public Builder(LaunchConfigurationMetadataOptions defaults) {
            Objects.requireNonNull(defaults);
            this.httpEndpoint = defaults.httpEndpoint;
            this.httpPutResponseHopLimit = defaults.httpPutResponseHopLimit;
            this.httpTokens = defaults.httpTokens;
        }

        @CustomType.Setter
        public Builder httpEndpoint(@Nullable String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @CustomType.Setter
        public Builder httpPutResponseHopLimit(@Nullable Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        @CustomType.Setter
        public Builder httpTokens(@Nullable String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public LaunchConfigurationMetadataOptions build() {
            LaunchConfigurationMetadataOptions o = new LaunchConfigurationMetadataOptions();
            o.httpEndpoint = this.httpEndpoint;
            o.httpPutResponseHopLimit = this.httpPutResponseHopLimit;
            o.httpTokens = this.httpTokens;
            return o;
        }
    }
}

