/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FlowLogDestinationOptions {
    @Nullable
    private String fileFormat;
    @Nullable
    private Boolean hiveCompatiblePartitions;
    @Nullable
    private Boolean perHourPartition;

    private FlowLogDestinationOptions() {
    }

    public Optional<String> fileFormat() {
        return Optional.ofNullable(this.fileFormat);
    }

    public Optional<Boolean> hiveCompatiblePartitions() {
        return Optional.ofNullable(this.hiveCompatiblePartitions);
    }

    public Optional<Boolean> perHourPartition() {
        return Optional.ofNullable(this.perHourPartition);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FlowLogDestinationOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String fileFormat;
        @Nullable
        private Boolean hiveCompatiblePartitions;
        @Nullable
        private Boolean perHourPartition;

        public Builder() {
        }

        public Builder(FlowLogDestinationOptions defaults) {
            Objects.requireNonNull(defaults);
            this.fileFormat = defaults.fileFormat;
            this.hiveCompatiblePartitions = defaults.hiveCompatiblePartitions;
            this.perHourPartition = defaults.perHourPartition;
        }

        @CustomType.Setter
        public Builder fileFormat(@Nullable String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @CustomType.Setter
        public Builder hiveCompatiblePartitions(@Nullable Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
            return this;
        }

        @CustomType.Setter
        public Builder perHourPartition(@Nullable Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
            return this;
        }

        public FlowLogDestinationOptions build() {
            FlowLogDestinationOptions o = new FlowLogDestinationOptions();
            o.fileFormat = this.fileFormat;
            o.hiveCompatiblePartitions = this.hiveCompatiblePartitions;
            o.perHourPartition = this.perHourPartition;
            return o;
        }
    }
}

