/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FleetTargetCapacitySpecification {
    private String defaultTargetCapacityType;
    @Nullable
    private Integer onDemandTargetCapacity;
    @Nullable
    private Integer spotTargetCapacity;
    @Nullable
    private String targetCapacityUnitType;
    private Integer totalTargetCapacity;

    private FleetTargetCapacitySpecification() {
    }

    public String defaultTargetCapacityType() {
        return this.defaultTargetCapacityType;
    }

    public Optional<Integer> onDemandTargetCapacity() {
        return Optional.ofNullable(this.onDemandTargetCapacity);
    }

    public Optional<Integer> spotTargetCapacity() {
        return Optional.ofNullable(this.spotTargetCapacity);
    }

    public Optional<String> targetCapacityUnitType() {
        return Optional.ofNullable(this.targetCapacityUnitType);
    }

    public Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FleetTargetCapacitySpecification defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String defaultTargetCapacityType;
        @Nullable
        private Integer onDemandTargetCapacity;
        @Nullable
        private Integer spotTargetCapacity;
        @Nullable
        private String targetCapacityUnitType;
        private Integer totalTargetCapacity;

        public Builder() {
        }

        public Builder(FleetTargetCapacitySpecification defaults) {
            Objects.requireNonNull(defaults);
            this.defaultTargetCapacityType = defaults.defaultTargetCapacityType;
            this.onDemandTargetCapacity = defaults.onDemandTargetCapacity;
            this.spotTargetCapacity = defaults.spotTargetCapacity;
            this.targetCapacityUnitType = defaults.targetCapacityUnitType;
            this.totalTargetCapacity = defaults.totalTargetCapacity;
        }

        @CustomType.Setter
        public Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = Objects.requireNonNull(defaultTargetCapacityType);
            return this;
        }

        @CustomType.Setter
        public Builder onDemandTargetCapacity(@Nullable Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        @CustomType.Setter
        public Builder spotTargetCapacity(@Nullable Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
            return this;
        }

        @CustomType.Setter
        public Builder targetCapacityUnitType(@Nullable String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
            return this;
        }

        @CustomType.Setter
        public Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = Objects.requireNonNull(totalTargetCapacity);
            return this;
        }

        public FleetTargetCapacitySpecification build() {
            FleetTargetCapacitySpecification o = new FleetTargetCapacitySpecification();
            o.defaultTargetCapacityType = this.defaultTargetCapacityType;
            o.onDemandTargetCapacity = this.onDemandTargetCapacity;
            o.spotTargetCapacity = this.spotTargetCapacity;
            o.targetCapacityUnitType = this.targetCapacityUnitType;
            o.totalTargetCapacity = this.totalTargetCapacity;
            return o;
        }
    }
}

