/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.FleetSpotOptionsMaintenanceStrategies;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FleetSpotOptions {
    @Nullable
    private String allocationStrategy;
    @Nullable
    private String instanceInterruptionBehavior;
    @Nullable
    private Integer instancePoolsToUseCount;
    @Nullable
    private FleetSpotOptionsMaintenanceStrategies maintenanceStrategies;

    private FleetSpotOptions() {
    }

    public Optional<String> allocationStrategy() {
        return Optional.ofNullable(this.allocationStrategy);
    }

    public Optional<String> instanceInterruptionBehavior() {
        return Optional.ofNullable(this.instanceInterruptionBehavior);
    }

    public Optional<Integer> instancePoolsToUseCount() {
        return Optional.ofNullable(this.instancePoolsToUseCount);
    }

    public Optional<FleetSpotOptionsMaintenanceStrategies> maintenanceStrategies() {
        return Optional.ofNullable(this.maintenanceStrategies);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FleetSpotOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String allocationStrategy;
        @Nullable
        private String instanceInterruptionBehavior;
        @Nullable
        private Integer instancePoolsToUseCount;
        @Nullable
        private FleetSpotOptionsMaintenanceStrategies maintenanceStrategies;

        public Builder() {
        }

        public Builder(FleetSpotOptions defaults) {
            Objects.requireNonNull(defaults);
            this.allocationStrategy = defaults.allocationStrategy;
            this.instanceInterruptionBehavior = defaults.instanceInterruptionBehavior;
            this.instancePoolsToUseCount = defaults.instancePoolsToUseCount;
            this.maintenanceStrategies = defaults.maintenanceStrategies;
        }

        @CustomType.Setter
        public Builder allocationStrategy(@Nullable String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @CustomType.Setter
        public Builder instanceInterruptionBehavior(@Nullable String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @CustomType.Setter
        public Builder instancePoolsToUseCount(@Nullable Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        @CustomType.Setter
        public Builder maintenanceStrategies(@Nullable FleetSpotOptionsMaintenanceStrategies maintenanceStrategies) {
            this.maintenanceStrategies = maintenanceStrategies;
            return this;
        }

        public FleetSpotOptions build() {
            FleetSpotOptions o = new FleetSpotOptions();
            o.allocationStrategy = this.allocationStrategy;
            o.instanceInterruptionBehavior = this.instanceInterruptionBehavior;
            o.instancePoolsToUseCount = this.instancePoolsToUseCount;
            o.maintenanceStrategies = this.maintenanceStrategies;
            return o;
        }
    }
}

