/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.dynamodb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TableGlobalSecondaryIndex {
    private String hashKey;
    private String name;
    @Nullable
    private List<String> nonKeyAttributes;
    private String projectionType;
    @Nullable
    private String rangeKey;
    @Nullable
    private Integer readCapacity;
    @Nullable
    private Integer writeCapacity;

    private TableGlobalSecondaryIndex() {
    }

    public String hashKey() {
        return this.hashKey;
    }

    public String name() {
        return this.name;
    }

    public List<String> nonKeyAttributes() {
        return this.nonKeyAttributes == null ? List.of() : this.nonKeyAttributes;
    }

    public String projectionType() {
        return this.projectionType;
    }

    public Optional<String> rangeKey() {
        return Optional.ofNullable(this.rangeKey);
    }

    public Optional<Integer> readCapacity() {
        return Optional.ofNullable(this.readCapacity);
    }

    public Optional<Integer> writeCapacity() {
        return Optional.ofNullable(this.writeCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TableGlobalSecondaryIndex defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String hashKey;
        private String name;
        @Nullable
        private List<String> nonKeyAttributes;
        private String projectionType;
        @Nullable
        private String rangeKey;
        @Nullable
        private Integer readCapacity;
        @Nullable
        private Integer writeCapacity;

        public Builder() {
        }

        public Builder(TableGlobalSecondaryIndex defaults) {
            Objects.requireNonNull(defaults);
            this.hashKey = defaults.hashKey;
            this.name = defaults.name;
            this.nonKeyAttributes = defaults.nonKeyAttributes;
            this.projectionType = defaults.projectionType;
            this.rangeKey = defaults.rangeKey;
            this.readCapacity = defaults.readCapacity;
            this.writeCapacity = defaults.writeCapacity;
        }

        @CustomType.Setter
        public Builder hashKey(String hashKey) {
            this.hashKey = Objects.requireNonNull(hashKey);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder nonKeyAttributes(@Nullable List<String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        public Builder nonKeyAttributes(String ... nonKeyAttributes) {
            return this.nonKeyAttributes(List.of(nonKeyAttributes));
        }

        @CustomType.Setter
        public Builder projectionType(String projectionType) {
            this.projectionType = Objects.requireNonNull(projectionType);
            return this;
        }

        @CustomType.Setter
        public Builder rangeKey(@Nullable String rangeKey) {
            this.rangeKey = rangeKey;
            return this;
        }

        @CustomType.Setter
        public Builder readCapacity(@Nullable Integer readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        @CustomType.Setter
        public Builder writeCapacity(@Nullable Integer writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        public TableGlobalSecondaryIndex build() {
            TableGlobalSecondaryIndex o = new TableGlobalSecondaryIndex();
            o.hashKey = this.hashKey;
            o.name = this.name;
            o.nonKeyAttributes = this.nonKeyAttributes;
            o.projectionType = this.projectionType;
            o.rangeKey = this.rangeKey;
            o.readCapacity = this.readCapacity;
            o.writeCapacity = this.writeCapacity;
            return o;
        }
    }
}

