/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.docdb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetOrderableDbInstanceResult {
    private List<String> availabilityZones;
    @Nullable
    private String engine;
    private String engineVersion;
    private String id;
    private String instanceClass;
    @Nullable
    private String licenseModel;
    @Nullable
    private List<String> preferredInstanceClasses;
    private Boolean vpc;

    private GetOrderableDbInstanceResult() {
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Optional<String> engine() {
        return Optional.ofNullable(this.engine);
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String id() {
        return this.id;
    }

    public String instanceClass() {
        return this.instanceClass;
    }

    public Optional<String> licenseModel() {
        return Optional.ofNullable(this.licenseModel);
    }

    public List<String> preferredInstanceClasses() {
        return this.preferredInstanceClasses == null ? List.of() : this.preferredInstanceClasses;
    }

    public Boolean vpc() {
        return this.vpc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetOrderableDbInstanceResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> availabilityZones;
        @Nullable
        private String engine;
        private String engineVersion;
        private String id;
        private String instanceClass;
        @Nullable
        private String licenseModel;
        @Nullable
        private List<String> preferredInstanceClasses;
        private Boolean vpc;

        public Builder() {
        }

        public Builder(GetOrderableDbInstanceResult defaults) {
            Objects.requireNonNull(defaults);
            this.availabilityZones = defaults.availabilityZones;
            this.engine = defaults.engine;
            this.engineVersion = defaults.engineVersion;
            this.id = defaults.id;
            this.instanceClass = defaults.instanceClass;
            this.licenseModel = defaults.licenseModel;
            this.preferredInstanceClasses = defaults.preferredInstanceClasses;
            this.vpc = defaults.vpc;
        }

        @CustomType.Setter
        public Builder availabilityZones(List<String> availabilityZones) {
            this.availabilityZones = Objects.requireNonNull(availabilityZones);
            return this;
        }

        public Builder availabilityZones(String ... availabilityZones) {
            return this.availabilityZones(List.of(availabilityZones));
        }

        @CustomType.Setter
        public Builder engine(@Nullable String engine) {
            this.engine = engine;
            return this;
        }

        @CustomType.Setter
        public Builder engineVersion(String engineVersion) {
            this.engineVersion = Objects.requireNonNull(engineVersion);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder instanceClass(String instanceClass) {
            this.instanceClass = Objects.requireNonNull(instanceClass);
            return this;
        }

        @CustomType.Setter
        public Builder licenseModel(@Nullable String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @CustomType.Setter
        public Builder preferredInstanceClasses(@Nullable List<String> preferredInstanceClasses) {
            this.preferredInstanceClasses = preferredInstanceClasses;
            return this;
        }

        public Builder preferredInstanceClasses(String ... preferredInstanceClasses) {
            return this.preferredInstanceClasses(List.of(preferredInstanceClasses));
        }

        @CustomType.Setter
        public Builder vpc(Boolean vpc) {
            this.vpc = Objects.requireNonNull(vpc);
            return this;
        }

        public GetOrderableDbInstanceResult build() {
            GetOrderableDbInstanceResult o = new GetOrderableDbInstanceResult();
            o.availabilityZones = this.availabilityZones;
            o.engine = this.engine;
            o.engineVersion = this.engineVersion;
            o.id = this.id;
            o.instanceClass = this.instanceClass;
            o.licenseModel = this.licenseModel;
            o.preferredInstanceClasses = this.preferredInstanceClasses;
            o.vpc = this.vpc;
            return o;
        }
    }
}

