/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.dms.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointElasticsearchSettings {
    private String endpointUri;
    @Nullable
    private Integer errorRetryDuration;
    @Nullable
    private Integer fullLoadErrorPercentage;
    private String serviceAccessRoleArn;

    private EndpointElasticsearchSettings() {
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public Optional<Integer> errorRetryDuration() {
        return Optional.ofNullable(this.errorRetryDuration);
    }

    public Optional<Integer> fullLoadErrorPercentage() {
        return Optional.ofNullable(this.fullLoadErrorPercentage);
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointElasticsearchSettings defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String endpointUri;
        @Nullable
        private Integer errorRetryDuration;
        @Nullable
        private Integer fullLoadErrorPercentage;
        private String serviceAccessRoleArn;

        public Builder() {
        }

        public Builder(EndpointElasticsearchSettings defaults) {
            Objects.requireNonNull(defaults);
            this.endpointUri = defaults.endpointUri;
            this.errorRetryDuration = defaults.errorRetryDuration;
            this.fullLoadErrorPercentage = defaults.fullLoadErrorPercentage;
            this.serviceAccessRoleArn = defaults.serviceAccessRoleArn;
        }

        @CustomType.Setter
        public Builder endpointUri(String endpointUri) {
            this.endpointUri = Objects.requireNonNull(endpointUri);
            return this;
        }

        @CustomType.Setter
        public Builder errorRetryDuration(@Nullable Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
            return this;
        }

        @CustomType.Setter
        public Builder fullLoadErrorPercentage(@Nullable Integer fullLoadErrorPercentage) {
            this.fullLoadErrorPercentage = fullLoadErrorPercentage;
            return this;
        }

        @CustomType.Setter
        public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = Objects.requireNonNull(serviceAccessRoleArn);
            return this;
        }

        public EndpointElasticsearchSettings build() {
            EndpointElasticsearchSettings o = new EndpointElasticsearchSettings();
            o.endpointUri = this.endpointUri;
            o.errorRetryDuration = this.errorRetryDuration;
            o.fullLoadErrorPercentage = this.fullLoadErrorPercentage;
            o.serviceAccessRoleArn = this.serviceAccessRoleArn;
            return o;
        }
    }
}

