/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cognito.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class UserPoolPasswordPolicy {
    @Nullable
    private Integer minimumLength;
    @Nullable
    private Boolean requireLowercase;
    @Nullable
    private Boolean requireNumbers;
    @Nullable
    private Boolean requireSymbols;
    @Nullable
    private Boolean requireUppercase;
    @Nullable
    private Integer temporaryPasswordValidityDays;

    private UserPoolPasswordPolicy() {
    }

    public Optional<Integer> minimumLength() {
        return Optional.ofNullable(this.minimumLength);
    }

    public Optional<Boolean> requireLowercase() {
        return Optional.ofNullable(this.requireLowercase);
    }

    public Optional<Boolean> requireNumbers() {
        return Optional.ofNullable(this.requireNumbers);
    }

    public Optional<Boolean> requireSymbols() {
        return Optional.ofNullable(this.requireSymbols);
    }

    public Optional<Boolean> requireUppercase() {
        return Optional.ofNullable(this.requireUppercase);
    }

    public Optional<Integer> temporaryPasswordValidityDays() {
        return Optional.ofNullable(this.temporaryPasswordValidityDays);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserPoolPasswordPolicy defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer minimumLength;
        @Nullable
        private Boolean requireLowercase;
        @Nullable
        private Boolean requireNumbers;
        @Nullable
        private Boolean requireSymbols;
        @Nullable
        private Boolean requireUppercase;
        @Nullable
        private Integer temporaryPasswordValidityDays;

        public Builder() {
        }

        public Builder(UserPoolPasswordPolicy defaults) {
            Objects.requireNonNull(defaults);
            this.minimumLength = defaults.minimumLength;
            this.requireLowercase = defaults.requireLowercase;
            this.requireNumbers = defaults.requireNumbers;
            this.requireSymbols = defaults.requireSymbols;
            this.requireUppercase = defaults.requireUppercase;
            this.temporaryPasswordValidityDays = defaults.temporaryPasswordValidityDays;
        }

        @CustomType.Setter
        public Builder minimumLength(@Nullable Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        @CustomType.Setter
        public Builder requireLowercase(@Nullable Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        @CustomType.Setter
        public Builder requireNumbers(@Nullable Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        @CustomType.Setter
        public Builder requireSymbols(@Nullable Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        @CustomType.Setter
        public Builder requireUppercase(@Nullable Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        @CustomType.Setter
        public Builder temporaryPasswordValidityDays(@Nullable Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
            return this;
        }

        public UserPoolPasswordPolicy build() {
            UserPoolPasswordPolicy o = new UserPoolPasswordPolicy();
            o.minimumLength = this.minimumLength;
            o.requireLowercase = this.requireLowercase;
            o.requireNumbers = this.requireNumbers;
            o.requireSymbols = this.requireSymbols;
            o.requireUppercase = this.requireUppercase;
            o.temporaryPasswordValidityDays = this.temporaryPasswordValidityDays;
            return o;
        }
    }
}

