/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codepipeline.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PipelineStageAction {
    private String category;
    @Nullable
    private Map<String, String> configuration;
    @Nullable
    private List<String> inputArtifacts;
    private String name;
    @Nullable
    private String namespace;
    @Nullable
    private List<String> outputArtifacts;
    private String owner;
    private String provider;
    @Nullable
    private String region;
    @Nullable
    private String roleArn;
    @Nullable
    private Integer runOrder;
    private String version;

    private PipelineStageAction() {
    }

    public String category() {
        return this.category;
    }

    public Map<String, String> configuration() {
        return this.configuration == null ? Map.of() : this.configuration;
    }

    public List<String> inputArtifacts() {
        return this.inputArtifacts == null ? List.of() : this.inputArtifacts;
    }

    public String name() {
        return this.name;
    }

    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public List<String> outputArtifacts() {
        return this.outputArtifacts == null ? List.of() : this.outputArtifacts;
    }

    public String owner() {
        return this.owner;
    }

    public String provider() {
        return this.provider;
    }

    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }

    public Optional<String> roleArn() {
        return Optional.ofNullable(this.roleArn);
    }

    public Optional<Integer> runOrder() {
        return Optional.ofNullable(this.runOrder);
    }

    public String version() {
        return this.version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineStageAction defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String category;
        @Nullable
        private Map<String, String> configuration;
        @Nullable
        private List<String> inputArtifacts;
        private String name;
        @Nullable
        private String namespace;
        @Nullable
        private List<String> outputArtifacts;
        private String owner;
        private String provider;
        @Nullable
        private String region;
        @Nullable
        private String roleArn;
        @Nullable
        private Integer runOrder;
        private String version;

        public Builder() {
        }

        public Builder(PipelineStageAction defaults) {
            Objects.requireNonNull(defaults);
            this.category = defaults.category;
            this.configuration = defaults.configuration;
            this.inputArtifacts = defaults.inputArtifacts;
            this.name = defaults.name;
            this.namespace = defaults.namespace;
            this.outputArtifacts = defaults.outputArtifacts;
            this.owner = defaults.owner;
            this.provider = defaults.provider;
            this.region = defaults.region;
            this.roleArn = defaults.roleArn;
            this.runOrder = defaults.runOrder;
            this.version = defaults.version;
        }

        @CustomType.Setter
        public Builder category(String category) {
            this.category = Objects.requireNonNull(category);
            return this;
        }

        @CustomType.Setter
        public Builder configuration(@Nullable Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        @CustomType.Setter
        public Builder inputArtifacts(@Nullable List<String> inputArtifacts) {
            this.inputArtifacts = inputArtifacts;
            return this;
        }

        public Builder inputArtifacts(String ... inputArtifacts) {
            return this.inputArtifacts(List.of(inputArtifacts));
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder outputArtifacts(@Nullable List<String> outputArtifacts) {
            this.outputArtifacts = outputArtifacts;
            return this;
        }

        public Builder outputArtifacts(String ... outputArtifacts) {
            return this.outputArtifacts(List.of(outputArtifacts));
        }

        @CustomType.Setter
        public Builder owner(String owner) {
            this.owner = Objects.requireNonNull(owner);
            return this;
        }

        @CustomType.Setter
        public Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider);
            return this;
        }

        @CustomType.Setter
        public Builder region(@Nullable String region) {
            this.region = region;
            return this;
        }

        @CustomType.Setter
        public Builder roleArn(@Nullable String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @CustomType.Setter
        public Builder runOrder(@Nullable Integer runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        @CustomType.Setter
        public Builder version(String version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public PipelineStageAction build() {
            PipelineStageAction o = new PipelineStageAction();
            o.category = this.category;
            o.configuration = this.configuration;
            o.inputArtifacts = this.inputArtifacts;
            o.name = this.name;
            o.namespace = this.namespace;
            o.outputArtifacts = this.outputArtifacts;
            o.owner = this.owner;
            o.provider = this.provider;
            o.region = this.region;
            o.roleArn = this.roleArn;
            o.runOrder = this.runOrder;
            o.version = this.version;
            return o;
        }
    }
}

