/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codepipeline.outputs;

import com.pulumi.aws.codepipeline.outputs.PipelineArtifactStoreEncryptionKey;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PipelineArtifactStore {
    @Nullable
    private PipelineArtifactStoreEncryptionKey encryptionKey;
    private String location;
    @Nullable
    private String region;
    private String type;

    private PipelineArtifactStore() {
    }

    public Optional<PipelineArtifactStoreEncryptionKey> encryptionKey() {
        return Optional.ofNullable(this.encryptionKey);
    }

    public String location() {
        return this.location;
    }

    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineArtifactStore defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private PipelineArtifactStoreEncryptionKey encryptionKey;
        private String location;
        @Nullable
        private String region;
        private String type;

        public Builder() {
        }

        public Builder(PipelineArtifactStore defaults) {
            Objects.requireNonNull(defaults);
            this.encryptionKey = defaults.encryptionKey;
            this.location = defaults.location;
            this.region = defaults.region;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder encryptionKey(@Nullable PipelineArtifactStoreEncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @CustomType.Setter
        public Builder location(String location) {
            this.location = Objects.requireNonNull(location);
            return this;
        }

        @CustomType.Setter
        public Builder region(@Nullable String region) {
            this.region = region;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public PipelineArtifactStore build() {
            PipelineArtifactStore o = new PipelineArtifactStore();
            o.encryptionKey = this.encryptionKey;
            o.location = this.location;
            o.region = this.region;
            o.type = this.type;
            return o;
        }
    }
}

