/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codedeploy.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DeploymentGroupAlarmConfiguration {
    @Nullable
    private List<String> alarms;
    @Nullable
    private Boolean enabled;
    @Nullable
    private Boolean ignorePollAlarmFailure;

    private DeploymentGroupAlarmConfiguration() {
    }

    public List<String> alarms() {
        return this.alarms == null ? List.of() : this.alarms;
    }

    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public Optional<Boolean> ignorePollAlarmFailure() {
        return Optional.ofNullable(this.ignorePollAlarmFailure);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeploymentGroupAlarmConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> alarms;
        @Nullable
        private Boolean enabled;
        @Nullable
        private Boolean ignorePollAlarmFailure;

        public Builder() {
        }

        public Builder(DeploymentGroupAlarmConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.alarms = defaults.alarms;
            this.enabled = defaults.enabled;
            this.ignorePollAlarmFailure = defaults.ignorePollAlarmFailure;
        }

        @CustomType.Setter
        public Builder alarms(@Nullable List<String> alarms) {
            this.alarms = alarms;
            return this;
        }

        public Builder alarms(String ... alarms) {
            return this.alarms(List.of(alarms));
        }

        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @CustomType.Setter
        public Builder ignorePollAlarmFailure(@Nullable Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public DeploymentGroupAlarmConfiguration build() {
            DeploymentGroupAlarmConfiguration o = new DeploymentGroupAlarmConfiguration();
            o.alarms = this.alarms;
            o.enabled = this.enabled;
            o.ignorePollAlarmFailure = this.ignorePollAlarmFailure;
            return o;
        }
    }
}

