/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild.outputs;

import com.pulumi.aws.codebuild.outputs.ProjectEnvironmentEnvironmentVariable;
import com.pulumi.aws.codebuild.outputs.ProjectEnvironmentRegistryCredential;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProjectEnvironment {
    @Nullable
    private String certificate;
    private String computeType;
    @Nullable
    private List<ProjectEnvironmentEnvironmentVariable> environmentVariables;
    private String image;
    @Nullable
    private String imagePullCredentialsType;
    @Nullable
    private Boolean privilegedMode;
    @Nullable
    private ProjectEnvironmentRegistryCredential registryCredential;
    private String type;

    private ProjectEnvironment() {
    }

    public Optional<String> certificate() {
        return Optional.ofNullable(this.certificate);
    }

    public String computeType() {
        return this.computeType;
    }

    public List<ProjectEnvironmentEnvironmentVariable> environmentVariables() {
        return this.environmentVariables == null ? List.of() : this.environmentVariables;
    }

    public String image() {
        return this.image;
    }

    public Optional<String> imagePullCredentialsType() {
        return Optional.ofNullable(this.imagePullCredentialsType);
    }

    public Optional<Boolean> privilegedMode() {
        return Optional.ofNullable(this.privilegedMode);
    }

    public Optional<ProjectEnvironmentRegistryCredential> registryCredential() {
        return Optional.ofNullable(this.registryCredential);
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectEnvironment defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String certificate;
        private String computeType;
        @Nullable
        private List<ProjectEnvironmentEnvironmentVariable> environmentVariables;
        private String image;
        @Nullable
        private String imagePullCredentialsType;
        @Nullable
        private Boolean privilegedMode;
        @Nullable
        private ProjectEnvironmentRegistryCredential registryCredential;
        private String type;

        public Builder() {
        }

        public Builder(ProjectEnvironment defaults) {
            Objects.requireNonNull(defaults);
            this.certificate = defaults.certificate;
            this.computeType = defaults.computeType;
            this.environmentVariables = defaults.environmentVariables;
            this.image = defaults.image;
            this.imagePullCredentialsType = defaults.imagePullCredentialsType;
            this.privilegedMode = defaults.privilegedMode;
            this.registryCredential = defaults.registryCredential;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder certificate(@Nullable String certificate) {
            this.certificate = certificate;
            return this;
        }

        @CustomType.Setter
        public Builder computeType(String computeType) {
            this.computeType = Objects.requireNonNull(computeType);
            return this;
        }

        @CustomType.Setter
        public Builder environmentVariables(@Nullable List<ProjectEnvironmentEnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder environmentVariables(ProjectEnvironmentEnvironmentVariable ... environmentVariables) {
            return this.environmentVariables(List.of(environmentVariables));
        }

        @CustomType.Setter
        public Builder image(String image) {
            this.image = Objects.requireNonNull(image);
            return this;
        }

        @CustomType.Setter
        public Builder imagePullCredentialsType(@Nullable String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
            return this;
        }

        @CustomType.Setter
        public Builder privilegedMode(@Nullable Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        @CustomType.Setter
        public Builder registryCredential(@Nullable ProjectEnvironmentRegistryCredential registryCredential) {
            this.registryCredential = registryCredential;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public ProjectEnvironment build() {
            ProjectEnvironment o = new ProjectEnvironment();
            o.certificate = this.certificate;
            o.computeType = this.computeType;
            o.environmentVariables = this.environmentVariables;
            o.image = this.image;
            o.imagePullCredentialsType = this.imagePullCredentialsType;
            o.privilegedMode = this.privilegedMode;
            o.registryCredential = this.registryCredential;
            o.type = this.type;
            return o;
        }
    }
}

