/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProjectCache {
    @Nullable
    private String location;
    @Nullable
    private List<String> modes;
    @Nullable
    private String type;

    private ProjectCache() {
    }

    public Optional<String> location() {
        return Optional.ofNullable(this.location);
    }

    public List<String> modes() {
        return this.modes == null ? List.of() : this.modes;
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectCache defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String location;
        @Nullable
        private List<String> modes;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(ProjectCache defaults) {
            Objects.requireNonNull(defaults);
            this.location = defaults.location;
            this.modes = defaults.modes;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder location(@Nullable String location) {
            this.location = location;
            return this;
        }

        @CustomType.Setter
        public Builder modes(@Nullable List<String> modes) {
            this.modes = modes;
            return this;
        }

        public Builder modes(String ... modes) {
            return this.modes(List.of(modes));
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public ProjectCache build() {
            ProjectCache o = new ProjectCache();
            o.location = this.location;
            o.modes = this.modes;
            o.type = this.type;
            return o;
        }
    }
}

