/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EventTargetBatchTarget {
    @Nullable
    private Integer arraySize;
    @Nullable
    private Integer jobAttempts;
    private String jobDefinition;
    private String jobName;

    private EventTargetBatchTarget() {
    }

    public Optional<Integer> arraySize() {
        return Optional.ofNullable(this.arraySize);
    }

    public Optional<Integer> jobAttempts() {
        return Optional.ofNullable(this.jobAttempts);
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public String jobName() {
        return this.jobName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventTargetBatchTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer arraySize;
        @Nullable
        private Integer jobAttempts;
        private String jobDefinition;
        private String jobName;

        public Builder() {
        }

        public Builder(EventTargetBatchTarget defaults) {
            Objects.requireNonNull(defaults);
            this.arraySize = defaults.arraySize;
            this.jobAttempts = defaults.jobAttempts;
            this.jobDefinition = defaults.jobDefinition;
            this.jobName = defaults.jobName;
        }

        @CustomType.Setter
        public Builder arraySize(@Nullable Integer arraySize) {
            this.arraySize = arraySize;
            return this;
        }

        @CustomType.Setter
        public Builder jobAttempts(@Nullable Integer jobAttempts) {
            this.jobAttempts = jobAttempts;
            return this;
        }

        @CustomType.Setter
        public Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = Objects.requireNonNull(jobDefinition);
            return this;
        }

        @CustomType.Setter
        public Builder jobName(String jobName) {
            this.jobName = Objects.requireNonNull(jobName);
            return this;
        }

        public EventTargetBatchTarget build() {
            EventTargetBatchTarget o = new EventTargetBatchTarget();
            o.arraySize = this.arraySize;
            o.jobAttempts = this.jobAttempts;
            o.jobDefinition = this.jobDefinition;
            o.jobName = this.jobName;
            return o;
        }
    }
}

