/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersOauthClientParameters;
import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersOauthOauthHttpParameters;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EventConnectionAuthParametersOauth {
    private String authorizationEndpoint;
    @Nullable
    private EventConnectionAuthParametersOauthClientParameters clientParameters;
    private String httpMethod;
    private EventConnectionAuthParametersOauthOauthHttpParameters oauthHttpParameters;

    private EventConnectionAuthParametersOauth() {
    }

    public String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public Optional<EventConnectionAuthParametersOauthClientParameters> clientParameters() {
        return Optional.ofNullable(this.clientParameters);
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public EventConnectionAuthParametersOauthOauthHttpParameters oauthHttpParameters() {
        return this.oauthHttpParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventConnectionAuthParametersOauth defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String authorizationEndpoint;
        @Nullable
        private EventConnectionAuthParametersOauthClientParameters clientParameters;
        private String httpMethod;
        private EventConnectionAuthParametersOauthOauthHttpParameters oauthHttpParameters;

        public Builder() {
        }

        public Builder(EventConnectionAuthParametersOauth defaults) {
            Objects.requireNonNull(defaults);
            this.authorizationEndpoint = defaults.authorizationEndpoint;
            this.clientParameters = defaults.clientParameters;
            this.httpMethod = defaults.httpMethod;
            this.oauthHttpParameters = defaults.oauthHttpParameters;
        }

        @CustomType.Setter
        public Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = Objects.requireNonNull(authorizationEndpoint);
            return this;
        }

        @CustomType.Setter
        public Builder clientParameters(@Nullable EventConnectionAuthParametersOauthClientParameters clientParameters) {
            this.clientParameters = clientParameters;
            return this;
        }

        @CustomType.Setter
        public Builder httpMethod(String httpMethod) {
            this.httpMethod = Objects.requireNonNull(httpMethod);
            return this;
        }

        @CustomType.Setter
        public Builder oauthHttpParameters(EventConnectionAuthParametersOauthOauthHttpParameters oauthHttpParameters) {
            this.oauthHttpParameters = Objects.requireNonNull(oauthHttpParameters);
            return this;
        }

        public EventConnectionAuthParametersOauth build() {
            EventConnectionAuthParametersOauth o = new EventConnectionAuthParametersOauth();
            o.authorizationEndpoint = this.authorizationEndpoint;
            o.clientParameters = this.clientParameters;
            o.httpMethod = this.httpMethod;
            o.oauthHttpParameters = this.oauthHttpParameters;
            return o;
        }
    }
}

