/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersApiKey;
import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersBasic;
import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersInvocationHttpParameters;
import com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersOauth;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EventConnectionAuthParameters {
    @Nullable
    private EventConnectionAuthParametersApiKey apiKey;
    @Nullable
    private EventConnectionAuthParametersBasic basic;
    @Nullable
    private EventConnectionAuthParametersInvocationHttpParameters invocationHttpParameters;
    @Nullable
    private EventConnectionAuthParametersOauth oauth;

    private EventConnectionAuthParameters() {
    }

    public Optional<EventConnectionAuthParametersApiKey> apiKey() {
        return Optional.ofNullable(this.apiKey);
    }

    public Optional<EventConnectionAuthParametersBasic> basic() {
        return Optional.ofNullable(this.basic);
    }

    public Optional<EventConnectionAuthParametersInvocationHttpParameters> invocationHttpParameters() {
        return Optional.ofNullable(this.invocationHttpParameters);
    }

    public Optional<EventConnectionAuthParametersOauth> oauth() {
        return Optional.ofNullable(this.oauth);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventConnectionAuthParameters defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private EventConnectionAuthParametersApiKey apiKey;
        @Nullable
        private EventConnectionAuthParametersBasic basic;
        @Nullable
        private EventConnectionAuthParametersInvocationHttpParameters invocationHttpParameters;
        @Nullable
        private EventConnectionAuthParametersOauth oauth;

        public Builder() {
        }

        public Builder(EventConnectionAuthParameters defaults) {
            Objects.requireNonNull(defaults);
            this.apiKey = defaults.apiKey;
            this.basic = defaults.basic;
            this.invocationHttpParameters = defaults.invocationHttpParameters;
            this.oauth = defaults.oauth;
        }

        @CustomType.Setter
        public Builder apiKey(@Nullable EventConnectionAuthParametersApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @CustomType.Setter
        public Builder basic(@Nullable EventConnectionAuthParametersBasic basic) {
            this.basic = basic;
            return this;
        }

        @CustomType.Setter
        public Builder invocationHttpParameters(@Nullable EventConnectionAuthParametersInvocationHttpParameters invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters;
            return this;
        }

        @CustomType.Setter
        public Builder oauth(@Nullable EventConnectionAuthParametersOauth oauth) {
            this.oauth = oauth;
            return this;
        }

        public EventConnectionAuthParameters build() {
            EventConnectionAuthParameters o = new EventConnectionAuthParameters();
            o.apiKey = this.apiKey;
            o.basic = this.basic;
            o.invocationHttpParameters = this.invocationHttpParameters;
            o.oauth = this.oauth;
            return o;
        }
    }
}

