/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch;

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EventConnectionArgs
extends ResourceArgs {
    public static final EventConnectionArgs Empty = new EventConnectionArgs();
    @Import(name="authParameters", required=true)
    private Output<EventConnectionAuthParametersArgs> authParameters;
    @Import(name="authorizationType", required=true)
    private Output<String> authorizationType;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="name")
    @Nullable
    private Output<String> name;

    public Output<EventConnectionAuthParametersArgs> authParameters() {
        return this.authParameters;
    }

    public Output<String> authorizationType() {
        return this.authorizationType;
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    private EventConnectionArgs() {
    }

    private EventConnectionArgs(EventConnectionArgs $) {
        this.authParameters = $.authParameters;
        this.authorizationType = $.authorizationType;
        this.description = $.description;
        this.name = $.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventConnectionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EventConnectionArgs $;

        public Builder() {
            this.$ = new EventConnectionArgs();
        }

        public Builder(EventConnectionArgs defaults) {
            this.$ = new EventConnectionArgs(Objects.requireNonNull(defaults));
        }

        public Builder authParameters(Output<EventConnectionAuthParametersArgs> authParameters) {
            this.$.authParameters = authParameters;
            return this;
        }

        public Builder authParameters(EventConnectionAuthParametersArgs authParameters) {
            return this.authParameters((Output<EventConnectionAuthParametersArgs>)Output.of((Object)((Object)authParameters)));
        }

        public Builder authorizationType(Output<String> authorizationType) {
            this.$.authorizationType = authorizationType;
            return this;
        }

        public Builder authorizationType(String authorizationType) {
            return this.authorizationType((Output<String>)Output.of((Object)authorizationType));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public EventConnectionArgs build() {
            this.$.authParameters = Objects.requireNonNull(this.$.authParameters, "expected parameter 'authParameters' to be non-null");
            this.$.authorizationType = Objects.requireNonNull(this.$.authorizationType, "expected parameter 'authorizationType' to be non-null");
            return this.$;
        }
    }
}

