/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudtrail.outputs;

import com.pulumi.aws.cloudtrail.outputs.TrailEventSelectorDataResource;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TrailEventSelector {
    @Nullable
    private List<TrailEventSelectorDataResource> dataResources;
    @Nullable
    private List<String> excludeManagementEventSources;
    @Nullable
    private Boolean includeManagementEvents;
    @Nullable
    private String readWriteType;

    private TrailEventSelector() {
    }

    public List<TrailEventSelectorDataResource> dataResources() {
        return this.dataResources == null ? List.of() : this.dataResources;
    }

    public List<String> excludeManagementEventSources() {
        return this.excludeManagementEventSources == null ? List.of() : this.excludeManagementEventSources;
    }

    public Optional<Boolean> includeManagementEvents() {
        return Optional.ofNullable(this.includeManagementEvents);
    }

    public Optional<String> readWriteType() {
        return Optional.ofNullable(this.readWriteType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TrailEventSelector defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<TrailEventSelectorDataResource> dataResources;
        @Nullable
        private List<String> excludeManagementEventSources;
        @Nullable
        private Boolean includeManagementEvents;
        @Nullable
        private String readWriteType;

        public Builder() {
        }

        public Builder(TrailEventSelector defaults) {
            Objects.requireNonNull(defaults);
            this.dataResources = defaults.dataResources;
            this.excludeManagementEventSources = defaults.excludeManagementEventSources;
            this.includeManagementEvents = defaults.includeManagementEvents;
            this.readWriteType = defaults.readWriteType;
        }

        @CustomType.Setter
        public Builder dataResources(@Nullable List<TrailEventSelectorDataResource> dataResources) {
            this.dataResources = dataResources;
            return this;
        }

        public Builder dataResources(TrailEventSelectorDataResource ... dataResources) {
            return this.dataResources(List.of(dataResources));
        }

        @CustomType.Setter
        public Builder excludeManagementEventSources(@Nullable List<String> excludeManagementEventSources) {
            this.excludeManagementEventSources = excludeManagementEventSources;
            return this;
        }

        public Builder excludeManagementEventSources(String ... excludeManagementEventSources) {
            return this.excludeManagementEventSources(List.of(excludeManagementEventSources));
        }

        @CustomType.Setter
        public Builder includeManagementEvents(@Nullable Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
            return this;
        }

        @CustomType.Setter
        public Builder readWriteType(@Nullable String readWriteType) {
            this.readWriteType = readWriteType;
            return this;
        }

        public TrailEventSelector build() {
            TrailEventSelector o = new TrailEventSelector();
            o.dataResources = this.dataResources;
            o.excludeManagementEventSources = this.excludeManagementEventSources;
            o.includeManagementEvents = this.includeManagementEvents;
            o.readWriteType = this.readWriteType;
            return o;
        }
    }
}

