/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainScalingParameters {
    @Nullable
    private String desiredInstanceType;
    @Nullable
    private Integer desiredPartitionCount;
    @Nullable
    private Integer desiredReplicationCount;

    private DomainScalingParameters() {
    }

    public Optional<String> desiredInstanceType() {
        return Optional.ofNullable(this.desiredInstanceType);
    }

    public Optional<Integer> desiredPartitionCount() {
        return Optional.ofNullable(this.desiredPartitionCount);
    }

    public Optional<Integer> desiredReplicationCount() {
        return Optional.ofNullable(this.desiredReplicationCount);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainScalingParameters defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String desiredInstanceType;
        @Nullable
        private Integer desiredPartitionCount;
        @Nullable
        private Integer desiredReplicationCount;

        public Builder() {
        }

        public Builder(DomainScalingParameters defaults) {
            Objects.requireNonNull(defaults);
            this.desiredInstanceType = defaults.desiredInstanceType;
            this.desiredPartitionCount = defaults.desiredPartitionCount;
            this.desiredReplicationCount = defaults.desiredReplicationCount;
        }

        @CustomType.Setter
        public Builder desiredInstanceType(@Nullable String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
            return this;
        }

        @CustomType.Setter
        public Builder desiredPartitionCount(@Nullable Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
            return this;
        }

        @CustomType.Setter
        public Builder desiredReplicationCount(@Nullable Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
            return this;
        }

        public DomainScalingParameters build() {
            DomainScalingParameters o = new DomainScalingParameters();
            o.desiredInstanceType = this.desiredInstanceType;
            o.desiredPartitionCount = this.desiredPartitionCount;
            o.desiredReplicationCount = this.desiredReplicationCount;
            return o;
        }
    }
}

