/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudfront.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DistributionTrustedKeyGroupItem {
    @Nullable
    private String keyGroupId;
    @Nullable
    private List<String> keyPairIds;

    private DistributionTrustedKeyGroupItem() {
    }

    public Optional<String> keyGroupId() {
        return Optional.ofNullable(this.keyGroupId);
    }

    public List<String> keyPairIds() {
        return this.keyPairIds == null ? List.of() : this.keyPairIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DistributionTrustedKeyGroupItem defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String keyGroupId;
        @Nullable
        private List<String> keyPairIds;

        public Builder() {
        }

        public Builder(DistributionTrustedKeyGroupItem defaults) {
            Objects.requireNonNull(defaults);
            this.keyGroupId = defaults.keyGroupId;
            this.keyPairIds = defaults.keyPairIds;
        }

        @CustomType.Setter
        public Builder keyGroupId(@Nullable String keyGroupId) {
            this.keyGroupId = keyGroupId;
            return this;
        }

        @CustomType.Setter
        public Builder keyPairIds(@Nullable List<String> keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        public Builder keyPairIds(String ... keyPairIds) {
            return this.keyPairIds(List.of(keyPairIds));
        }

        public DistributionTrustedKeyGroupItem build() {
            DistributionTrustedKeyGroupItem o = new DistributionTrustedKeyGroupItem();
            o.keyGroupId = this.keyGroupId;
            o.keyPairIds = this.keyPairIds;
            return o;
        }
    }
}

