/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudfront.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DistributionOriginCustomOriginConfig {
    private Integer httpPort;
    private Integer httpsPort;
    @Nullable
    private Integer originKeepaliveTimeout;
    private String originProtocolPolicy;
    @Nullable
    private Integer originReadTimeout;
    private List<String> originSslProtocols;

    private DistributionOriginCustomOriginConfig() {
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public Optional<Integer> originKeepaliveTimeout() {
        return Optional.ofNullable(this.originKeepaliveTimeout);
    }

    public String originProtocolPolicy() {
        return this.originProtocolPolicy;
    }

    public Optional<Integer> originReadTimeout() {
        return Optional.ofNullable(this.originReadTimeout);
    }

    public List<String> originSslProtocols() {
        return this.originSslProtocols;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DistributionOriginCustomOriginConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Integer httpPort;
        private Integer httpsPort;
        @Nullable
        private Integer originKeepaliveTimeout;
        private String originProtocolPolicy;
        @Nullable
        private Integer originReadTimeout;
        private List<String> originSslProtocols;

        public Builder() {
        }

        public Builder(DistributionOriginCustomOriginConfig defaults) {
            Objects.requireNonNull(defaults);
            this.httpPort = defaults.httpPort;
            this.httpsPort = defaults.httpsPort;
            this.originKeepaliveTimeout = defaults.originKeepaliveTimeout;
            this.originProtocolPolicy = defaults.originProtocolPolicy;
            this.originReadTimeout = defaults.originReadTimeout;
            this.originSslProtocols = defaults.originSslProtocols;
        }

        @CustomType.Setter
        public Builder httpPort(Integer httpPort) {
            this.httpPort = Objects.requireNonNull(httpPort);
            return this;
        }

        @CustomType.Setter
        public Builder httpsPort(Integer httpsPort) {
            this.httpsPort = Objects.requireNonNull(httpsPort);
            return this;
        }

        @CustomType.Setter
        public Builder originKeepaliveTimeout(@Nullable Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        @CustomType.Setter
        public Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = Objects.requireNonNull(originProtocolPolicy);
            return this;
        }

        @CustomType.Setter
        public Builder originReadTimeout(@Nullable Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        @CustomType.Setter
        public Builder originSslProtocols(List<String> originSslProtocols) {
            this.originSslProtocols = Objects.requireNonNull(originSslProtocols);
            return this;
        }

        public Builder originSslProtocols(String ... originSslProtocols) {
            return this.originSslProtocols(List.of(originSslProtocols));
        }

        public DistributionOriginCustomOriginConfig build() {
            DistributionOriginCustomOriginConfig o = new DistributionOriginCustomOriginConfig();
            o.httpPort = this.httpPort;
            o.httpsPort = this.httpsPort;
            o.originKeepaliveTimeout = this.originKeepaliveTimeout;
            o.originProtocolPolicy = this.originProtocolPolicy;
            o.originReadTimeout = this.originReadTimeout;
            o.originSslProtocols = this.originSslProtocols;
            return o;
        }
    }
}

