/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudfront.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DistributionLoggingConfig {
    private String bucket;
    @Nullable
    private Boolean includeCookies;
    @Nullable
    private String prefix;

    private DistributionLoggingConfig() {
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<Boolean> includeCookies() {
        return Optional.ofNullable(this.includeCookies);
    }

    public Optional<String> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DistributionLoggingConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucket;
        @Nullable
        private Boolean includeCookies;
        @Nullable
        private String prefix;

        public Builder() {
        }

        public Builder(DistributionLoggingConfig defaults) {
            Objects.requireNonNull(defaults);
            this.bucket = defaults.bucket;
            this.includeCookies = defaults.includeCookies;
            this.prefix = defaults.prefix;
        }

        @CustomType.Setter
        public Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket);
            return this;
        }

        @CustomType.Setter
        public Builder includeCookies(@Nullable Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        @CustomType.Setter
        public Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        public DistributionLoggingConfig build() {
            DistributionLoggingConfig o = new DistributionLoggingConfig();
            o.bucket = this.bucket;
            o.includeCookies = this.includeCookies;
            o.prefix = this.prefix;
            return o;
        }
    }
}

