/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudformation.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StackSetOperationPreferences {
    @Nullable
    private Integer failureToleranceCount;
    @Nullable
    private Integer failureTolerancePercentage;
    @Nullable
    private Integer maxConcurrentCount;
    @Nullable
    private Integer maxConcurrentPercentage;
    @Nullable
    private String regionConcurrencyType;
    @Nullable
    private List<String> regionOrders;

    private StackSetOperationPreferences() {
    }

    public Optional<Integer> failureToleranceCount() {
        return Optional.ofNullable(this.failureToleranceCount);
    }

    public Optional<Integer> failureTolerancePercentage() {
        return Optional.ofNullable(this.failureTolerancePercentage);
    }

    public Optional<Integer> maxConcurrentCount() {
        return Optional.ofNullable(this.maxConcurrentCount);
    }

    public Optional<Integer> maxConcurrentPercentage() {
        return Optional.ofNullable(this.maxConcurrentPercentage);
    }

    public Optional<String> regionConcurrencyType() {
        return Optional.ofNullable(this.regionConcurrencyType);
    }

    public List<String> regionOrders() {
        return this.regionOrders == null ? List.of() : this.regionOrders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StackSetOperationPreferences defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer failureToleranceCount;
        @Nullable
        private Integer failureTolerancePercentage;
        @Nullable
        private Integer maxConcurrentCount;
        @Nullable
        private Integer maxConcurrentPercentage;
        @Nullable
        private String regionConcurrencyType;
        @Nullable
        private List<String> regionOrders;

        public Builder() {
        }

        public Builder(StackSetOperationPreferences defaults) {
            Objects.requireNonNull(defaults);
            this.failureToleranceCount = defaults.failureToleranceCount;
            this.failureTolerancePercentage = defaults.failureTolerancePercentage;
            this.maxConcurrentCount = defaults.maxConcurrentCount;
            this.maxConcurrentPercentage = defaults.maxConcurrentPercentage;
            this.regionConcurrencyType = defaults.regionConcurrencyType;
            this.regionOrders = defaults.regionOrders;
        }

        @CustomType.Setter
        public Builder failureToleranceCount(@Nullable Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
            return this;
        }

        @CustomType.Setter
        public Builder failureTolerancePercentage(@Nullable Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        @CustomType.Setter
        public Builder maxConcurrentCount(@Nullable Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
            return this;
        }

        @CustomType.Setter
        public Builder maxConcurrentPercentage(@Nullable Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
            return this;
        }

        @CustomType.Setter
        public Builder regionConcurrencyType(@Nullable String regionConcurrencyType) {
            this.regionConcurrencyType = regionConcurrencyType;
            return this;
        }

        @CustomType.Setter
        public Builder regionOrders(@Nullable List<String> regionOrders) {
            this.regionOrders = regionOrders;
            return this;
        }

        public Builder regionOrders(String ... regionOrders) {
            return this.regionOrders(List.of(regionOrders));
        }

        public StackSetOperationPreferences build() {
            StackSetOperationPreferences o = new StackSetOperationPreferences();
            o.failureToleranceCount = this.failureToleranceCount;
            o.failureTolerancePercentage = this.failureTolerancePercentage;
            o.maxConcurrentCount = this.maxConcurrentCount;
            o.maxConcurrentPercentage = this.maxConcurrentPercentage;
            o.regionConcurrencyType = this.regionConcurrencyType;
            o.regionOrders = this.regionOrders;
            return o;
        }
    }
}

