/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cleanrooms.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CollaborationMember {
    private String accountId;
    private String displayName;
    private List<String> memberAbilities;
    @Nullable
    private String status;

    private CollaborationMember() {
    }

    public String accountId() {
        return this.accountId;
    }

    public String displayName() {
        return this.displayName;
    }

    public List<String> memberAbilities() {
        return this.memberAbilities;
    }

    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CollaborationMember defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String accountId;
        private String displayName;
        private List<String> memberAbilities;
        @Nullable
        private String status;

        public Builder() {
        }

        public Builder(CollaborationMember defaults) {
            Objects.requireNonNull(defaults);
            this.accountId = defaults.accountId;
            this.displayName = defaults.displayName;
            this.memberAbilities = defaults.memberAbilities;
            this.status = defaults.status;
        }

        @CustomType.Setter
        public Builder accountId(String accountId) {
            this.accountId = Objects.requireNonNull(accountId);
            return this;
        }

        @CustomType.Setter
        public Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        @CustomType.Setter
        public Builder memberAbilities(List<String> memberAbilities) {
            this.memberAbilities = Objects.requireNonNull(memberAbilities);
            return this;
        }

        public Builder memberAbilities(String ... memberAbilities) {
            return this.memberAbilities(List.of(memberAbilities));
        }

        @CustomType.Setter
        public Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public CollaborationMember build() {
            CollaborationMember o = new CollaborationMember();
            o.accountId = this.accountId;
            o.displayName = this.displayName;
            o.memberAbilities = this.memberAbilities;
            o.status = this.status;
            return o;
        }
    }
}

