/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cfg.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RemediationConfigurationParameter {
    private String name;
    @Nullable
    private String resourceValue;
    @Nullable
    private String staticValue;
    @Nullable
    private List<String> staticValues;

    private RemediationConfigurationParameter() {
    }

    public String name() {
        return this.name;
    }

    public Optional<String> resourceValue() {
        return Optional.ofNullable(this.resourceValue);
    }

    public Optional<String> staticValue() {
        return Optional.ofNullable(this.staticValue);
    }

    public List<String> staticValues() {
        return this.staticValues == null ? List.of() : this.staticValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RemediationConfigurationParameter defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        @Nullable
        private String resourceValue;
        @Nullable
        private String staticValue;
        @Nullable
        private List<String> staticValues;

        public Builder() {
        }

        public Builder(RemediationConfigurationParameter defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.resourceValue = defaults.resourceValue;
            this.staticValue = defaults.staticValue;
            this.staticValues = defaults.staticValues;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder resourceValue(@Nullable String resourceValue) {
            this.resourceValue = resourceValue;
            return this;
        }

        @CustomType.Setter
        public Builder staticValue(@Nullable String staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        @CustomType.Setter
        public Builder staticValues(@Nullable List<String> staticValues) {
            this.staticValues = staticValues;
            return this;
        }

        public Builder staticValues(String ... staticValues) {
            return this.staticValues(List.of(staticValues));
        }

        public RemediationConfigurationParameter build() {
            RemediationConfigurationParameter o = new RemediationConfigurationParameter();
            o.name = this.name;
            o.resourceValue = this.resourceValue;
            o.staticValue = this.staticValue;
            o.staticValues = this.staticValues;
            return o;
        }
    }
}

