/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.budgets.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class BudgetNotification {
    private String comparisonOperator;
    private String notificationType;
    @Nullable
    private List<String> subscriberEmailAddresses;
    @Nullable
    private List<String> subscriberSnsTopicArns;
    private Double threshold;
    private String thresholdType;

    private BudgetNotification() {
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public String notificationType() {
        return this.notificationType;
    }

    public List<String> subscriberEmailAddresses() {
        return this.subscriberEmailAddresses == null ? List.of() : this.subscriberEmailAddresses;
    }

    public List<String> subscriberSnsTopicArns() {
        return this.subscriberSnsTopicArns == null ? List.of() : this.subscriberSnsTopicArns;
    }

    public Double threshold() {
        return this.threshold;
    }

    public String thresholdType() {
        return this.thresholdType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BudgetNotification defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String comparisonOperator;
        private String notificationType;
        @Nullable
        private List<String> subscriberEmailAddresses;
        @Nullable
        private List<String> subscriberSnsTopicArns;
        private Double threshold;
        private String thresholdType;

        public Builder() {
        }

        public Builder(BudgetNotification defaults) {
            Objects.requireNonNull(defaults);
            this.comparisonOperator = defaults.comparisonOperator;
            this.notificationType = defaults.notificationType;
            this.subscriberEmailAddresses = defaults.subscriberEmailAddresses;
            this.subscriberSnsTopicArns = defaults.subscriberSnsTopicArns;
            this.threshold = defaults.threshold;
            this.thresholdType = defaults.thresholdType;
        }

        @CustomType.Setter
        public Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = Objects.requireNonNull(comparisonOperator);
            return this;
        }

        @CustomType.Setter
        public Builder notificationType(String notificationType) {
            this.notificationType = Objects.requireNonNull(notificationType);
            return this;
        }

        @CustomType.Setter
        public Builder subscriberEmailAddresses(@Nullable List<String> subscriberEmailAddresses) {
            this.subscriberEmailAddresses = subscriberEmailAddresses;
            return this;
        }

        public Builder subscriberEmailAddresses(String ... subscriberEmailAddresses) {
            return this.subscriberEmailAddresses(List.of(subscriberEmailAddresses));
        }

        @CustomType.Setter
        public Builder subscriberSnsTopicArns(@Nullable List<String> subscriberSnsTopicArns) {
            this.subscriberSnsTopicArns = subscriberSnsTopicArns;
            return this;
        }

        public Builder subscriberSnsTopicArns(String ... subscriberSnsTopicArns) {
            return this.subscriberSnsTopicArns(List.of(subscriberSnsTopicArns));
        }

        @CustomType.Setter
        public Builder threshold(Double threshold) {
            this.threshold = Objects.requireNonNull(threshold);
            return this;
        }

        @CustomType.Setter
        public Builder thresholdType(String thresholdType) {
            this.thresholdType = Objects.requireNonNull(thresholdType);
            return this;
        }

        public BudgetNotification build() {
            BudgetNotification o = new BudgetNotification();
            o.comparisonOperator = this.comparisonOperator;
            o.notificationType = this.notificationType;
            o.subscriberEmailAddresses = this.subscriberEmailAddresses;
            o.subscriberSnsTopicArns = this.subscriberSnsTopicArns;
            o.threshold = this.threshold;
            o.thresholdType = this.thresholdType;
            return o;
        }
    }
}

