/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.backup.outputs;

import com.pulumi.aws.backup.outputs.PlanRuleCopyAction;
import com.pulumi.aws.backup.outputs.PlanRuleLifecycle;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PlanRule {
    @Nullable
    private Integer completionWindow;
    @Nullable
    private List<PlanRuleCopyAction> copyActions;
    @Nullable
    private Boolean enableContinuousBackup;
    @Nullable
    private PlanRuleLifecycle lifecycle;
    @Nullable
    private Map<String, String> recoveryPointTags;
    private String ruleName;
    @Nullable
    private String schedule;
    @Nullable
    private Integer startWindow;
    private String targetVaultName;

    private PlanRule() {
    }

    public Optional<Integer> completionWindow() {
        return Optional.ofNullable(this.completionWindow);
    }

    public List<PlanRuleCopyAction> copyActions() {
        return this.copyActions == null ? List.of() : this.copyActions;
    }

    public Optional<Boolean> enableContinuousBackup() {
        return Optional.ofNullable(this.enableContinuousBackup);
    }

    public Optional<PlanRuleLifecycle> lifecycle() {
        return Optional.ofNullable(this.lifecycle);
    }

    public Map<String, String> recoveryPointTags() {
        return this.recoveryPointTags == null ? Map.of() : this.recoveryPointTags;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public Optional<String> schedule() {
        return Optional.ofNullable(this.schedule);
    }

    public Optional<Integer> startWindow() {
        return Optional.ofNullable(this.startWindow);
    }

    public String targetVaultName() {
        return this.targetVaultName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PlanRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer completionWindow;
        @Nullable
        private List<PlanRuleCopyAction> copyActions;
        @Nullable
        private Boolean enableContinuousBackup;
        @Nullable
        private PlanRuleLifecycle lifecycle;
        @Nullable
        private Map<String, String> recoveryPointTags;
        private String ruleName;
        @Nullable
        private String schedule;
        @Nullable
        private Integer startWindow;
        private String targetVaultName;

        public Builder() {
        }

        public Builder(PlanRule defaults) {
            Objects.requireNonNull(defaults);
            this.completionWindow = defaults.completionWindow;
            this.copyActions = defaults.copyActions;
            this.enableContinuousBackup = defaults.enableContinuousBackup;
            this.lifecycle = defaults.lifecycle;
            this.recoveryPointTags = defaults.recoveryPointTags;
            this.ruleName = defaults.ruleName;
            this.schedule = defaults.schedule;
            this.startWindow = defaults.startWindow;
            this.targetVaultName = defaults.targetVaultName;
        }

        @CustomType.Setter
        public Builder completionWindow(@Nullable Integer completionWindow) {
            this.completionWindow = completionWindow;
            return this;
        }

        @CustomType.Setter
        public Builder copyActions(@Nullable List<PlanRuleCopyAction> copyActions) {
            this.copyActions = copyActions;
            return this;
        }

        public Builder copyActions(PlanRuleCopyAction ... copyActions) {
            return this.copyActions(List.of(copyActions));
        }

        @CustomType.Setter
        public Builder enableContinuousBackup(@Nullable Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
            return this;
        }

        @CustomType.Setter
        public Builder lifecycle(@Nullable PlanRuleLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @CustomType.Setter
        public Builder recoveryPointTags(@Nullable Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = recoveryPointTags;
            return this;
        }

        @CustomType.Setter
        public Builder ruleName(String ruleName) {
            this.ruleName = Objects.requireNonNull(ruleName);
            return this;
        }

        @CustomType.Setter
        public Builder schedule(@Nullable String schedule) {
            this.schedule = schedule;
            return this;
        }

        @CustomType.Setter
        public Builder startWindow(@Nullable Integer startWindow) {
            this.startWindow = startWindow;
            return this;
        }

        @CustomType.Setter
        public Builder targetVaultName(String targetVaultName) {
            this.targetVaultName = Objects.requireNonNull(targetVaultName);
            return this;
        }

        public PlanRule build() {
            PlanRule o = new PlanRule();
            o.completionWindow = this.completionWindow;
            o.copyActions = this.copyActions;
            o.enableContinuousBackup = this.enableContinuousBackup;
            o.lifecycle = this.lifecycle;
            o.recoveryPointTags = this.recoveryPointTags;
            o.ruleName = this.ruleName;
            o.schedule = this.schedule;
            o.startWindow = this.startWindow;
            o.targetVaultName = this.targetVaultName;
            return o;
        }
    }
}

