/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.autoscaling.outputs;

import com.pulumi.aws.autoscaling.outputs.GroupWarmPoolInstanceReusePolicy;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GroupWarmPool {
    @Nullable
    private GroupWarmPoolInstanceReusePolicy instanceReusePolicy;
    @Nullable
    private Integer maxGroupPreparedCapacity;
    @Nullable
    private Integer minSize;
    @Nullable
    private String poolState;

    private GroupWarmPool() {
    }

    public Optional<GroupWarmPoolInstanceReusePolicy> instanceReusePolicy() {
        return Optional.ofNullable(this.instanceReusePolicy);
    }

    public Optional<Integer> maxGroupPreparedCapacity() {
        return Optional.ofNullable(this.maxGroupPreparedCapacity);
    }

    public Optional<Integer> minSize() {
        return Optional.ofNullable(this.minSize);
    }

    public Optional<String> poolState() {
        return Optional.ofNullable(this.poolState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupWarmPool defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private GroupWarmPoolInstanceReusePolicy instanceReusePolicy;
        @Nullable
        private Integer maxGroupPreparedCapacity;
        @Nullable
        private Integer minSize;
        @Nullable
        private String poolState;

        public Builder() {
        }

        public Builder(GroupWarmPool defaults) {
            Objects.requireNonNull(defaults);
            this.instanceReusePolicy = defaults.instanceReusePolicy;
            this.maxGroupPreparedCapacity = defaults.maxGroupPreparedCapacity;
            this.minSize = defaults.minSize;
            this.poolState = defaults.poolState;
        }

        @CustomType.Setter
        public Builder instanceReusePolicy(@Nullable GroupWarmPoolInstanceReusePolicy instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        @CustomType.Setter
        public Builder maxGroupPreparedCapacity(@Nullable Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        @CustomType.Setter
        public Builder minSize(@Nullable Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        @CustomType.Setter
        public Builder poolState(@Nullable String poolState) {
            this.poolState = poolState;
            return this;
        }

        public GroupWarmPool build() {
            GroupWarmPool o = new GroupWarmPool();
            o.instanceReusePolicy = this.instanceReusePolicy;
            o.maxGroupPreparedCapacity = this.maxGroupPreparedCapacity;
            o.minSize = this.minSize;
            o.poolState = this.poolState;
            return o;
        }
    }
}

