/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.autoscaling.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GroupInstanceRefreshPreferences {
    @Nullable
    private Boolean autoRollback;
    @Nullable
    private String checkpointDelay;
    @Nullable
    private List<Integer> checkpointPercentages;
    @Nullable
    private String instanceWarmup;
    @Nullable
    private Integer minHealthyPercentage;
    @Nullable
    private String scaleInProtectedInstances;
    @Nullable
    private Boolean skipMatching;
    @Nullable
    private String standbyInstances;

    private GroupInstanceRefreshPreferences() {
    }

    public Optional<Boolean> autoRollback() {
        return Optional.ofNullable(this.autoRollback);
    }

    public Optional<String> checkpointDelay() {
        return Optional.ofNullable(this.checkpointDelay);
    }

    public List<Integer> checkpointPercentages() {
        return this.checkpointPercentages == null ? List.of() : this.checkpointPercentages;
    }

    public Optional<String> instanceWarmup() {
        return Optional.ofNullable(this.instanceWarmup);
    }

    public Optional<Integer> minHealthyPercentage() {
        return Optional.ofNullable(this.minHealthyPercentage);
    }

    public Optional<String> scaleInProtectedInstances() {
        return Optional.ofNullable(this.scaleInProtectedInstances);
    }

    public Optional<Boolean> skipMatching() {
        return Optional.ofNullable(this.skipMatching);
    }

    public Optional<String> standbyInstances() {
        return Optional.ofNullable(this.standbyInstances);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupInstanceRefreshPreferences defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean autoRollback;
        @Nullable
        private String checkpointDelay;
        @Nullable
        private List<Integer> checkpointPercentages;
        @Nullable
        private String instanceWarmup;
        @Nullable
        private Integer minHealthyPercentage;
        @Nullable
        private String scaleInProtectedInstances;
        @Nullable
        private Boolean skipMatching;
        @Nullable
        private String standbyInstances;

        public Builder() {
        }

        public Builder(GroupInstanceRefreshPreferences defaults) {
            Objects.requireNonNull(defaults);
            this.autoRollback = defaults.autoRollback;
            this.checkpointDelay = defaults.checkpointDelay;
            this.checkpointPercentages = defaults.checkpointPercentages;
            this.instanceWarmup = defaults.instanceWarmup;
            this.minHealthyPercentage = defaults.minHealthyPercentage;
            this.scaleInProtectedInstances = defaults.scaleInProtectedInstances;
            this.skipMatching = defaults.skipMatching;
            this.standbyInstances = defaults.standbyInstances;
        }

        @CustomType.Setter
        public Builder autoRollback(@Nullable Boolean autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        @CustomType.Setter
        public Builder checkpointDelay(@Nullable String checkpointDelay) {
            this.checkpointDelay = checkpointDelay;
            return this;
        }

        @CustomType.Setter
        public Builder checkpointPercentages(@Nullable List<Integer> checkpointPercentages) {
            this.checkpointPercentages = checkpointPercentages;
            return this;
        }

        public Builder checkpointPercentages(Integer ... checkpointPercentages) {
            return this.checkpointPercentages(List.of(checkpointPercentages));
        }

        @CustomType.Setter
        public Builder instanceWarmup(@Nullable String instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
            return this;
        }

        @CustomType.Setter
        public Builder minHealthyPercentage(@Nullable Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        @CustomType.Setter
        public Builder scaleInProtectedInstances(@Nullable String scaleInProtectedInstances) {
            this.scaleInProtectedInstances = scaleInProtectedInstances;
            return this;
        }

        @CustomType.Setter
        public Builder skipMatching(@Nullable Boolean skipMatching) {
            this.skipMatching = skipMatching;
            return this;
        }

        @CustomType.Setter
        public Builder standbyInstances(@Nullable String standbyInstances) {
            this.standbyInstances = standbyInstances;
            return this;
        }

        public GroupInstanceRefreshPreferences build() {
            GroupInstanceRefreshPreferences o = new GroupInstanceRefreshPreferences();
            o.autoRollback = this.autoRollback;
            o.checkpointDelay = this.checkpointDelay;
            o.checkpointPercentages = this.checkpointPercentages;
            o.instanceWarmup = this.instanceWarmup;
            o.minHealthyPercentage = this.minHealthyPercentage;
            o.scaleInProtectedInstances = this.scaleInProtectedInstances;
            o.skipMatching = this.skipMatching;
            o.standbyInstances = this.standbyInstances;
            return o;
        }
    }
}

