/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.appstream.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StackStorageConnector {
    private String connectorType;
    @Nullable
    private List<String> domains;
    @Nullable
    private String resourceIdentifier;

    private StackStorageConnector() {
    }

    public String connectorType() {
        return this.connectorType;
    }

    public List<String> domains() {
        return this.domains == null ? List.of() : this.domains;
    }

    public Optional<String> resourceIdentifier() {
        return Optional.ofNullable(this.resourceIdentifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StackStorageConnector defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String connectorType;
        @Nullable
        private List<String> domains;
        @Nullable
        private String resourceIdentifier;

        public Builder() {
        }

        public Builder(StackStorageConnector defaults) {
            Objects.requireNonNull(defaults);
            this.connectorType = defaults.connectorType;
            this.domains = defaults.domains;
            this.resourceIdentifier = defaults.resourceIdentifier;
        }

        @CustomType.Setter
        public Builder connectorType(String connectorType) {
            this.connectorType = Objects.requireNonNull(connectorType);
            return this;
        }

        @CustomType.Setter
        public Builder domains(@Nullable List<String> domains) {
            this.domains = domains;
            return this;
        }

        public Builder domains(String ... domains) {
            return this.domains(List.of(domains));
        }

        @CustomType.Setter
        public Builder resourceIdentifier(@Nullable String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public StackStorageConnector build() {
            StackStorageConnector o = new StackStorageConnector();
            o.connectorType = this.connectorType;
            o.domains = this.domains;
            o.resourceIdentifier = this.resourceIdentifier;
            return o;
        }
    }
}

