/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apprunner.outputs;

import com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationAuthenticationConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationCodeRepository;
import com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationImageRepository;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceSourceConfiguration {
    @Nullable
    private ServiceSourceConfigurationAuthenticationConfiguration authenticationConfiguration;
    @Nullable
    private Boolean autoDeploymentsEnabled;
    @Nullable
    private ServiceSourceConfigurationCodeRepository codeRepository;
    @Nullable
    private ServiceSourceConfigurationImageRepository imageRepository;

    private ServiceSourceConfiguration() {
    }

    public Optional<ServiceSourceConfigurationAuthenticationConfiguration> authenticationConfiguration() {
        return Optional.ofNullable(this.authenticationConfiguration);
    }

    public Optional<Boolean> autoDeploymentsEnabled() {
        return Optional.ofNullable(this.autoDeploymentsEnabled);
    }

    public Optional<ServiceSourceConfigurationCodeRepository> codeRepository() {
        return Optional.ofNullable(this.codeRepository);
    }

    public Optional<ServiceSourceConfigurationImageRepository> imageRepository() {
        return Optional.ofNullable(this.imageRepository);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceSourceConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private ServiceSourceConfigurationAuthenticationConfiguration authenticationConfiguration;
        @Nullable
        private Boolean autoDeploymentsEnabled;
        @Nullable
        private ServiceSourceConfigurationCodeRepository codeRepository;
        @Nullable
        private ServiceSourceConfigurationImageRepository imageRepository;

        public Builder() {
        }

        public Builder(ServiceSourceConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.authenticationConfiguration = defaults.authenticationConfiguration;
            this.autoDeploymentsEnabled = defaults.autoDeploymentsEnabled;
            this.codeRepository = defaults.codeRepository;
            this.imageRepository = defaults.imageRepository;
        }

        @CustomType.Setter
        public Builder authenticationConfiguration(@Nullable ServiceSourceConfigurationAuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        @CustomType.Setter
        public Builder autoDeploymentsEnabled(@Nullable Boolean autoDeploymentsEnabled) {
            this.autoDeploymentsEnabled = autoDeploymentsEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder codeRepository(@Nullable ServiceSourceConfigurationCodeRepository codeRepository) {
            this.codeRepository = codeRepository;
            return this;
        }

        @CustomType.Setter
        public Builder imageRepository(@Nullable ServiceSourceConfigurationImageRepository imageRepository) {
            this.imageRepository = imageRepository;
            return this;
        }

        public ServiceSourceConfiguration build() {
            ServiceSourceConfiguration o = new ServiceSourceConfiguration();
            o.authenticationConfiguration = this.authenticationConfiguration;
            o.autoDeploymentsEnabled = this.autoDeploymentsEnabled;
            o.codeRepository = this.codeRepository;
            o.imageRepository = this.imageRepository;
            return o;
        }
    }
}

