/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.appmesh.outputs;

import com.pulumi.aws.appmesh.outputs.VirtualNodeSpecBackend;
import com.pulumi.aws.appmesh.outputs.VirtualNodeSpecBackendDefaults;
import com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListener;
import com.pulumi.aws.appmesh.outputs.VirtualNodeSpecLogging;
import com.pulumi.aws.appmesh.outputs.VirtualNodeSpecServiceDiscovery;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VirtualNodeSpec {
    @Nullable
    private VirtualNodeSpecBackendDefaults backendDefaults;
    @Nullable
    private List<VirtualNodeSpecBackend> backends;
    @Nullable
    private List<VirtualNodeSpecListener> listeners;
    @Nullable
    private VirtualNodeSpecLogging logging;
    @Nullable
    private VirtualNodeSpecServiceDiscovery serviceDiscovery;

    private VirtualNodeSpec() {
    }

    public Optional<VirtualNodeSpecBackendDefaults> backendDefaults() {
        return Optional.ofNullable(this.backendDefaults);
    }

    public List<VirtualNodeSpecBackend> backends() {
        return this.backends == null ? List.of() : this.backends;
    }

    public List<VirtualNodeSpecListener> listeners() {
        return this.listeners == null ? List.of() : this.listeners;
    }

    public Optional<VirtualNodeSpecLogging> logging() {
        return Optional.ofNullable(this.logging);
    }

    public Optional<VirtualNodeSpecServiceDiscovery> serviceDiscovery() {
        return Optional.ofNullable(this.serviceDiscovery);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VirtualNodeSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private VirtualNodeSpecBackendDefaults backendDefaults;
        @Nullable
        private List<VirtualNodeSpecBackend> backends;
        @Nullable
        private List<VirtualNodeSpecListener> listeners;
        @Nullable
        private VirtualNodeSpecLogging logging;
        @Nullable
        private VirtualNodeSpecServiceDiscovery serviceDiscovery;

        public Builder() {
        }

        public Builder(VirtualNodeSpec defaults) {
            Objects.requireNonNull(defaults);
            this.backendDefaults = defaults.backendDefaults;
            this.backends = defaults.backends;
            this.listeners = defaults.listeners;
            this.logging = defaults.logging;
            this.serviceDiscovery = defaults.serviceDiscovery;
        }

        @CustomType.Setter
        public Builder backendDefaults(@Nullable VirtualNodeSpecBackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        @CustomType.Setter
        public Builder backends(@Nullable List<VirtualNodeSpecBackend> backends) {
            this.backends = backends;
            return this;
        }

        public Builder backends(VirtualNodeSpecBackend ... backends) {
            return this.backends(List.of(backends));
        }

        @CustomType.Setter
        public Builder listeners(@Nullable List<VirtualNodeSpecListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder listeners(VirtualNodeSpecListener ... listeners) {
            return this.listeners(List.of(listeners));
        }

        @CustomType.Setter
        public Builder logging(@Nullable VirtualNodeSpecLogging logging) {
            this.logging = logging;
            return this;
        }

        @CustomType.Setter
        public Builder serviceDiscovery(@Nullable VirtualNodeSpecServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public VirtualNodeSpec build() {
            VirtualNodeSpec o = new VirtualNodeSpec();
            o.backendDefaults = this.backendDefaults;
            o.backends = this.backends;
            o.listeners = this.listeners;
            o.logging = this.logging;
            o.serviceDiscovery = this.serviceDiscovery;
            return o;
        }
    }
}

