/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.appmesh.outputs;

import com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRoute;
import com.pulumi.aws.appmesh.outputs.RouteSpecHttp2Route;
import com.pulumi.aws.appmesh.outputs.RouteSpecHttpRoute;
import com.pulumi.aws.appmesh.outputs.RouteSpecTcpRoute;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RouteSpec {
    @Nullable
    private RouteSpecGrpcRoute grpcRoute;
    @Nullable
    private RouteSpecHttp2Route http2Route;
    @Nullable
    private RouteSpecHttpRoute httpRoute;
    @Nullable
    private Integer priority;
    @Nullable
    private RouteSpecTcpRoute tcpRoute;

    private RouteSpec() {
    }

    public Optional<RouteSpecGrpcRoute> grpcRoute() {
        return Optional.ofNullable(this.grpcRoute);
    }

    public Optional<RouteSpecHttp2Route> http2Route() {
        return Optional.ofNullable(this.http2Route);
    }

    public Optional<RouteSpecHttpRoute> httpRoute() {
        return Optional.ofNullable(this.httpRoute);
    }

    public Optional<Integer> priority() {
        return Optional.ofNullable(this.priority);
    }

    public Optional<RouteSpecTcpRoute> tcpRoute() {
        return Optional.ofNullable(this.tcpRoute);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RouteSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private RouteSpecGrpcRoute grpcRoute;
        @Nullable
        private RouteSpecHttp2Route http2Route;
        @Nullable
        private RouteSpecHttpRoute httpRoute;
        @Nullable
        private Integer priority;
        @Nullable
        private RouteSpecTcpRoute tcpRoute;

        public Builder() {
        }

        public Builder(RouteSpec defaults) {
            Objects.requireNonNull(defaults);
            this.grpcRoute = defaults.grpcRoute;
            this.http2Route = defaults.http2Route;
            this.httpRoute = defaults.httpRoute;
            this.priority = defaults.priority;
            this.tcpRoute = defaults.tcpRoute;
        }

        @CustomType.Setter
        public Builder grpcRoute(@Nullable RouteSpecGrpcRoute grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        @CustomType.Setter
        public Builder http2Route(@Nullable RouteSpecHttp2Route http2Route) {
            this.http2Route = http2Route;
            return this;
        }

        @CustomType.Setter
        public Builder httpRoute(@Nullable RouteSpecHttpRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        @CustomType.Setter
        public Builder priority(@Nullable Integer priority) {
            this.priority = priority;
            return this;
        }

        @CustomType.Setter
        public Builder tcpRoute(@Nullable RouteSpecTcpRoute tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        public RouteSpec build() {
            RouteSpec o = new RouteSpec();
            o.grpcRoute = this.grpcRoute;
            o.http2Route = this.http2Route;
            o.httpRoute = this.httpRoute;
            o.priority = this.priority;
            o.tcpRoute = this.tcpRoute;
            return o;
        }
    }
}

