/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apigatewayv2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StageRouteSetting {
    @Nullable
    private Boolean dataTraceEnabled;
    @Nullable
    private Boolean detailedMetricsEnabled;
    @Nullable
    private String loggingLevel;
    private String routeKey;
    @Nullable
    private Integer throttlingBurstLimit;
    @Nullable
    private Double throttlingRateLimit;

    private StageRouteSetting() {
    }

    public Optional<Boolean> dataTraceEnabled() {
        return Optional.ofNullable(this.dataTraceEnabled);
    }

    public Optional<Boolean> detailedMetricsEnabled() {
        return Optional.ofNullable(this.detailedMetricsEnabled);
    }

    public Optional<String> loggingLevel() {
        return Optional.ofNullable(this.loggingLevel);
    }

    public String routeKey() {
        return this.routeKey;
    }

    public Optional<Integer> throttlingBurstLimit() {
        return Optional.ofNullable(this.throttlingBurstLimit);
    }

    public Optional<Double> throttlingRateLimit() {
        return Optional.ofNullable(this.throttlingRateLimit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StageRouteSetting defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean dataTraceEnabled;
        @Nullable
        private Boolean detailedMetricsEnabled;
        @Nullable
        private String loggingLevel;
        private String routeKey;
        @Nullable
        private Integer throttlingBurstLimit;
        @Nullable
        private Double throttlingRateLimit;

        public Builder() {
        }

        public Builder(StageRouteSetting defaults) {
            Objects.requireNonNull(defaults);
            this.dataTraceEnabled = defaults.dataTraceEnabled;
            this.detailedMetricsEnabled = defaults.detailedMetricsEnabled;
            this.loggingLevel = defaults.loggingLevel;
            this.routeKey = defaults.routeKey;
            this.throttlingBurstLimit = defaults.throttlingBurstLimit;
            this.throttlingRateLimit = defaults.throttlingRateLimit;
        }

        @CustomType.Setter
        public Builder dataTraceEnabled(@Nullable Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder detailedMetricsEnabled(@Nullable Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder loggingLevel(@Nullable String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @CustomType.Setter
        public Builder routeKey(String routeKey) {
            this.routeKey = Objects.requireNonNull(routeKey);
            return this;
        }

        @CustomType.Setter
        public Builder throttlingBurstLimit(@Nullable Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        @CustomType.Setter
        public Builder throttlingRateLimit(@Nullable Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public StageRouteSetting build() {
            StageRouteSetting o = new StageRouteSetting();
            o.dataTraceEnabled = this.dataTraceEnabled;
            o.detailedMetricsEnabled = this.detailedMetricsEnabled;
            o.loggingLevel = this.loggingLevel;
            o.routeKey = this.routeKey;
            o.throttlingBurstLimit = this.throttlingBurstLimit;
            o.throttlingRateLimit = this.throttlingRateLimit;
            return o;
        }
    }
}

