/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.apigateway.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class RestApiEndpointConfiguration {
    private String types;
    @Nullable
    private List<String> vpcEndpointIds;

    private RestApiEndpointConfiguration() {
    }

    public String types() {
        return this.types;
    }

    public List<String> vpcEndpointIds() {
        return this.vpcEndpointIds == null ? List.of() : this.vpcEndpointIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RestApiEndpointConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String types;
        @Nullable
        private List<String> vpcEndpointIds;

        public Builder() {
        }

        public Builder(RestApiEndpointConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.types = defaults.types;
            this.vpcEndpointIds = defaults.vpcEndpointIds;
        }

        @CustomType.Setter
        public Builder types(String types) {
            this.types = Objects.requireNonNull(types);
            return this;
        }

        @CustomType.Setter
        public Builder vpcEndpointIds(@Nullable List<String> vpcEndpointIds) {
            this.vpcEndpointIds = vpcEndpointIds;
            return this;
        }

        public Builder vpcEndpointIds(String ... vpcEndpointIds) {
            return this.vpcEndpointIds(List.of(vpcEndpointIds));
        }

        public RestApiEndpointConfiguration build() {
            RestApiEndpointConfiguration o = new RestApiEndpointConfiguration();
            o.types = this.types;
            o.vpcEndpointIds = this.vpcEndpointIds;
            return o;
        }
    }
}

