/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.alb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LoadBalancerAccessLogs {
    private String bucket;
    @Nullable
    private Boolean enabled;
    @Nullable
    private String prefix;

    private LoadBalancerAccessLogs() {
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public Optional<String> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadBalancerAccessLogs defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucket;
        @Nullable
        private Boolean enabled;
        @Nullable
        private String prefix;

        public Builder() {
        }

        public Builder(LoadBalancerAccessLogs defaults) {
            Objects.requireNonNull(defaults);
            this.bucket = defaults.bucket;
            this.enabled = defaults.enabled;
            this.prefix = defaults.prefix;
        }

        @CustomType.Setter
        public Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket);
            return this;
        }

        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @CustomType.Setter
        public Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        public LoadBalancerAccessLogs build() {
            LoadBalancerAccessLogs o = new LoadBalancerAccessLogs();
            o.bucket = this.bucket;
            o.enabled = this.enabled;
            o.prefix = this.prefix;
            return o;
        }
    }
}

