/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.acm.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetCertificateResult {
    private String arn;
    private String certificate;
    private String certificateChain;
    private String domain;
    private String id;
    @Nullable
    private List<String> keyTypes;
    @Nullable
    private Boolean mostRecent;
    private String status;
    @Nullable
    private List<String> statuses;
    private Map<String, String> tags;
    @Nullable
    private List<String> types;

    private GetCertificateResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String certificate() {
        return this.certificate;
    }

    public String certificateChain() {
        return this.certificateChain;
    }

    public String domain() {
        return this.domain;
    }

    public String id() {
        return this.id;
    }

    public List<String> keyTypes() {
        return this.keyTypes == null ? List.of() : this.keyTypes;
    }

    public Optional<Boolean> mostRecent() {
        return Optional.ofNullable(this.mostRecent);
    }

    public String status() {
        return this.status;
    }

    public List<String> statuses() {
        return this.statuses == null ? List.of() : this.statuses;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<String> types() {
        return this.types == null ? List.of() : this.types;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetCertificateResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String certificate;
        private String certificateChain;
        private String domain;
        private String id;
        @Nullable
        private List<String> keyTypes;
        @Nullable
        private Boolean mostRecent;
        private String status;
        @Nullable
        private List<String> statuses;
        private Map<String, String> tags;
        @Nullable
        private List<String> types;

        public Builder() {
        }

        public Builder(GetCertificateResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.certificate = defaults.certificate;
            this.certificateChain = defaults.certificateChain;
            this.domain = defaults.domain;
            this.id = defaults.id;
            this.keyTypes = defaults.keyTypes;
            this.mostRecent = defaults.mostRecent;
            this.status = defaults.status;
            this.statuses = defaults.statuses;
            this.tags = defaults.tags;
            this.types = defaults.types;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder certificate(String certificate) {
            this.certificate = Objects.requireNonNull(certificate);
            return this;
        }

        @CustomType.Setter
        public Builder certificateChain(String certificateChain) {
            this.certificateChain = Objects.requireNonNull(certificateChain);
            return this;
        }

        @CustomType.Setter
        public Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder keyTypes(@Nullable List<String> keyTypes) {
            this.keyTypes = keyTypes;
            return this;
        }

        public Builder keyTypes(String ... keyTypes) {
            return this.keyTypes(List.of(keyTypes));
        }

        @CustomType.Setter
        public Builder mostRecent(@Nullable Boolean mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @CustomType.Setter
        public Builder status(String status) {
            this.status = Objects.requireNonNull(status);
            return this;
        }

        @CustomType.Setter
        public Builder statuses(@Nullable List<String> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder statuses(String ... statuses) {
            return this.statuses(List.of(statuses));
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder types(@Nullable List<String> types) {
            this.types = types;
            return this;
        }

        public Builder types(String ... types) {
            return this.types(List.of(types));
        }

        public GetCertificateResult build() {
            GetCertificateResult o = new GetCertificateResult();
            o.arn = this.arn;
            o.certificate = this.certificate;
            o.certificateChain = this.certificateChain;
            o.domain = this.domain;
            o.id = this.id;
            o.keyTypes = this.keyTypes;
            o.mostRecent = this.mostRecent;
            o.status = this.status;
            o.statuses = this.statuses;
            o.tags = this.tags;
            o.types = this.types;
            return o;
        }
    }
}

