// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.xray;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Double;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SamplingRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final SamplingRuleArgs Empty = new SamplingRuleArgs();

    /**
     * Matches attributes derived from the request.
     * 
     */
    @Import(name="attributes")
    private @Nullable Output<Map<String,String>> attributes;

    /**
     * @return Matches attributes derived from the request.
     * 
     */
    public Optional<Output<Map<String,String>>> attributes() {
        return Optional.ofNullable(this.attributes);
    }

    /**
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     * 
     */
    @Import(name="fixedRate", required=true)
    private Output<Double> fixedRate;

    /**
     * @return The percentage of matching requests to instrument, after the reservoir is exhausted.
     * 
     */
    public Output<Double> fixedRate() {
        return this.fixedRate;
    }

    /**
     * Matches the hostname from a request URL.
     * 
     */
    @Import(name="host", required=true)
    private Output<String> host;

    /**
     * @return Matches the hostname from a request URL.
     * 
     */
    public Output<String> host() {
        return this.host;
    }

    /**
     * Matches the HTTP method of a request.
     * 
     */
    @Import(name="httpMethod", required=true)
    private Output<String> httpMethod;

    /**
     * @return Matches the HTTP method of a request.
     * 
     */
    public Output<String> httpMethod() {
        return this.httpMethod;
    }

    /**
     * The priority of the sampling rule.
     * 
     */
    @Import(name="priority", required=true)
    private Output<Integer> priority;

    /**
     * @return The priority of the sampling rule.
     * 
     */
    public Output<Integer> priority() {
        return this.priority;
    }

    /**
     * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     * 
     */
    @Import(name="reservoirSize", required=true)
    private Output<Integer> reservoirSize;

    /**
     * @return A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     * 
     */
    public Output<Integer> reservoirSize() {
        return this.reservoirSize;
    }

    /**
     * Matches the ARN of the AWS resource on which the service runs.
     * 
     */
    @Import(name="resourceArn", required=true)
    private Output<String> resourceArn;

    /**
     * @return Matches the ARN of the AWS resource on which the service runs.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }

    /**
     * The name of the sampling rule.
     * 
     */
    @Import(name="ruleName")
    private @Nullable Output<String> ruleName;

    /**
     * @return The name of the sampling rule.
     * 
     */
    public Optional<Output<String>> ruleName() {
        return Optional.ofNullable(this.ruleName);
    }

    /**
     * Matches the `name` that the service uses to identify itself in segments.
     * 
     */
    @Import(name="serviceName", required=true)
    private Output<String> serviceName;

    /**
     * @return Matches the `name` that the service uses to identify itself in segments.
     * 
     */
    public Output<String> serviceName() {
        return this.serviceName;
    }

    /**
     * Matches the `origin` that the service uses to identify its type in segments.
     * 
     */
    @Import(name="serviceType", required=true)
    private Output<String> serviceType;

    /**
     * @return Matches the `origin` that the service uses to identify its type in segments.
     * 
     */
    public Output<String> serviceType() {
        return this.serviceType;
    }

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Matches the path from a request URL.
     * 
     */
    @Import(name="urlPath", required=true)
    private Output<String> urlPath;

    /**
     * @return Matches the path from a request URL.
     * 
     */
    public Output<String> urlPath() {
        return this.urlPath;
    }

    /**
     * The version of the sampling rule format (`1` )
     * 
     */
    @Import(name="version", required=true)
    private Output<Integer> version;

    /**
     * @return The version of the sampling rule format (`1` )
     * 
     */
    public Output<Integer> version() {
        return this.version;
    }

    private SamplingRuleArgs() {}

    private SamplingRuleArgs(SamplingRuleArgs $) {
        this.attributes = $.attributes;
        this.fixedRate = $.fixedRate;
        this.host = $.host;
        this.httpMethod = $.httpMethod;
        this.priority = $.priority;
        this.reservoirSize = $.reservoirSize;
        this.resourceArn = $.resourceArn;
        this.ruleName = $.ruleName;
        this.serviceName = $.serviceName;
        this.serviceType = $.serviceType;
        this.tags = $.tags;
        this.urlPath = $.urlPath;
        this.version = $.version;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SamplingRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SamplingRuleArgs $;

        public Builder() {
            $ = new SamplingRuleArgs();
        }

        public Builder(SamplingRuleArgs defaults) {
            $ = new SamplingRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param attributes Matches attributes derived from the request.
         * 
         * @return builder
         * 
         */
        public Builder attributes(@Nullable Output<Map<String,String>> attributes) {
            $.attributes = attributes;
            return this;
        }

        /**
         * @param attributes Matches attributes derived from the request.
         * 
         * @return builder
         * 
         */
        public Builder attributes(Map<String,String> attributes) {
            return attributes(Output.of(attributes));
        }

        /**
         * @param fixedRate The percentage of matching requests to instrument, after the reservoir is exhausted.
         * 
         * @return builder
         * 
         */
        public Builder fixedRate(Output<Double> fixedRate) {
            $.fixedRate = fixedRate;
            return this;
        }

        /**
         * @param fixedRate The percentage of matching requests to instrument, after the reservoir is exhausted.
         * 
         * @return builder
         * 
         */
        public Builder fixedRate(Double fixedRate) {
            return fixedRate(Output.of(fixedRate));
        }

        /**
         * @param host Matches the hostname from a request URL.
         * 
         * @return builder
         * 
         */
        public Builder host(Output<String> host) {
            $.host = host;
            return this;
        }

        /**
         * @param host Matches the hostname from a request URL.
         * 
         * @return builder
         * 
         */
        public Builder host(String host) {
            return host(Output.of(host));
        }

        /**
         * @param httpMethod Matches the HTTP method of a request.
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(Output<String> httpMethod) {
            $.httpMethod = httpMethod;
            return this;
        }

        /**
         * @param httpMethod Matches the HTTP method of a request.
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(String httpMethod) {
            return httpMethod(Output.of(httpMethod));
        }

        /**
         * @param priority The priority of the sampling rule.
         * 
         * @return builder
         * 
         */
        public Builder priority(Output<Integer> priority) {
            $.priority = priority;
            return this;
        }

        /**
         * @param priority The priority of the sampling rule.
         * 
         * @return builder
         * 
         */
        public Builder priority(Integer priority) {
            return priority(Output.of(priority));
        }

        /**
         * @param reservoirSize A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
         * 
         * @return builder
         * 
         */
        public Builder reservoirSize(Output<Integer> reservoirSize) {
            $.reservoirSize = reservoirSize;
            return this;
        }

        /**
         * @param reservoirSize A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
         * 
         * @return builder
         * 
         */
        public Builder reservoirSize(Integer reservoirSize) {
            return reservoirSize(Output.of(reservoirSize));
        }

        /**
         * @param resourceArn Matches the ARN of the AWS resource on which the service runs.
         * 
         * @return builder
         * 
         */
        public Builder resourceArn(Output<String> resourceArn) {
            $.resourceArn = resourceArn;
            return this;
        }

        /**
         * @param resourceArn Matches the ARN of the AWS resource on which the service runs.
         * 
         * @return builder
         * 
         */
        public Builder resourceArn(String resourceArn) {
            return resourceArn(Output.of(resourceArn));
        }

        /**
         * @param ruleName The name of the sampling rule.
         * 
         * @return builder
         * 
         */
        public Builder ruleName(@Nullable Output<String> ruleName) {
            $.ruleName = ruleName;
            return this;
        }

        /**
         * @param ruleName The name of the sampling rule.
         * 
         * @return builder
         * 
         */
        public Builder ruleName(String ruleName) {
            return ruleName(Output.of(ruleName));
        }

        /**
         * @param serviceName Matches the `name` that the service uses to identify itself in segments.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(Output<String> serviceName) {
            $.serviceName = serviceName;
            return this;
        }

        /**
         * @param serviceName Matches the `name` that the service uses to identify itself in segments.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(String serviceName) {
            return serviceName(Output.of(serviceName));
        }

        /**
         * @param serviceType Matches the `origin` that the service uses to identify its type in segments.
         * 
         * @return builder
         * 
         */
        public Builder serviceType(Output<String> serviceType) {
            $.serviceType = serviceType;
            return this;
        }

        /**
         * @param serviceType Matches the `origin` that the service uses to identify its type in segments.
         * 
         * @return builder
         * 
         */
        public Builder serviceType(String serviceType) {
            return serviceType(Output.of(serviceType));
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param urlPath Matches the path from a request URL.
         * 
         * @return builder
         * 
         */
        public Builder urlPath(Output<String> urlPath) {
            $.urlPath = urlPath;
            return this;
        }

        /**
         * @param urlPath Matches the path from a request URL.
         * 
         * @return builder
         * 
         */
        public Builder urlPath(String urlPath) {
            return urlPath(Output.of(urlPath));
        }

        /**
         * @param version The version of the sampling rule format (`1` )
         * 
         * @return builder
         * 
         */
        public Builder version(Output<Integer> version) {
            $.version = version;
            return this;
        }

        /**
         * @param version The version of the sampling rule format (`1` )
         * 
         * @return builder
         * 
         */
        public Builder version(Integer version) {
            return version(Output.of(version));
        }

        public SamplingRuleArgs build() {
            $.fixedRate = Objects.requireNonNull($.fixedRate, "expected parameter 'fixedRate' to be non-null");
            $.host = Objects.requireNonNull($.host, "expected parameter 'host' to be non-null");
            $.httpMethod = Objects.requireNonNull($.httpMethod, "expected parameter 'httpMethod' to be non-null");
            $.priority = Objects.requireNonNull($.priority, "expected parameter 'priority' to be non-null");
            $.reservoirSize = Objects.requireNonNull($.reservoirSize, "expected parameter 'reservoirSize' to be non-null");
            $.resourceArn = Objects.requireNonNull($.resourceArn, "expected parameter 'resourceArn' to be non-null");
            $.serviceName = Objects.requireNonNull($.serviceName, "expected parameter 'serviceName' to be non-null");
            $.serviceType = Objects.requireNonNull($.serviceType, "expected parameter 'serviceType' to be non-null");
            $.urlPath = Objects.requireNonNull($.urlPath, "expected parameter 'urlPath' to be non-null");
            $.version = Objects.requireNonNull($.version, "expected parameter 'version' to be non-null");
            return $;
        }
    }

}
