// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.wafv2.outputs;

import com.pulumi.aws.wafv2.outputs.WebAclRuleAction;
import com.pulumi.aws.wafv2.outputs.WebAclRuleCaptchaConfig;
import com.pulumi.aws.wafv2.outputs.WebAclRuleOverrideAction;
import com.pulumi.aws.wafv2.outputs.WebAclRuleRuleLabel;
import com.pulumi.aws.wafv2.outputs.WebAclRuleStatement;
import com.pulumi.aws.wafv2.outputs.WebAclRuleVisibilityConfig;
import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class WebAclRule {
    /**
     * @return Action that AWS WAF should take on a web request when it matches the rule&#39;s statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
     * 
     */
    private @Nullable WebAclRuleAction action;
    /**
     * @return Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     * 
     */
    private @Nullable WebAclRuleCaptchaConfig captchaConfig;
    /**
     * @return Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_&lt;account-id&gt;_&lt;web-acl-guid&gt;_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
     * 
     */
    private String name;
    /**
     * @return Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
     * 
     */
    private @Nullable WebAclRuleOverrideAction overrideAction;
    /**
     * @return If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     * 
     */
    private Integer priority;
    /**
     * @return Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     * 
     */
    private @Nullable List<WebAclRuleRuleLabel> ruleLabels;
    /**
     * @return The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
     * 
     */
    private WebAclRuleStatement statement;
    /**
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     * 
     */
    private WebAclRuleVisibilityConfig visibilityConfig;

    private WebAclRule() {}
    /**
     * @return Action that AWS WAF should take on a web request when it matches the rule&#39;s statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
     * 
     */
    public Optional<WebAclRuleAction> action() {
        return Optional.ofNullable(this.action);
    }
    /**
     * @return Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     * 
     */
    public Optional<WebAclRuleCaptchaConfig> captchaConfig() {
        return Optional.ofNullable(this.captchaConfig);
    }
    /**
     * @return Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_&lt;account-id&gt;_&lt;web-acl-guid&gt;_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
     * 
     */
    public Optional<WebAclRuleOverrideAction> overrideAction() {
        return Optional.ofNullable(this.overrideAction);
    }
    /**
     * @return If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     * 
     */
    public Integer priority() {
        return this.priority;
    }
    /**
     * @return Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     * 
     */
    public List<WebAclRuleRuleLabel> ruleLabels() {
        return this.ruleLabels == null ? List.of() : this.ruleLabels;
    }
    /**
     * @return The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
     * 
     */
    public WebAclRuleStatement statement() {
        return this.statement;
    }
    /**
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     * 
     */
    public WebAclRuleVisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebAclRule defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable WebAclRuleAction action;
        private @Nullable WebAclRuleCaptchaConfig captchaConfig;
        private String name;
        private @Nullable WebAclRuleOverrideAction overrideAction;
        private Integer priority;
        private @Nullable List<WebAclRuleRuleLabel> ruleLabels;
        private WebAclRuleStatement statement;
        private WebAclRuleVisibilityConfig visibilityConfig;
        public Builder() {}
        public Builder(WebAclRule defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.action = defaults.action;
    	      this.captchaConfig = defaults.captchaConfig;
    	      this.name = defaults.name;
    	      this.overrideAction = defaults.overrideAction;
    	      this.priority = defaults.priority;
    	      this.ruleLabels = defaults.ruleLabels;
    	      this.statement = defaults.statement;
    	      this.visibilityConfig = defaults.visibilityConfig;
        }

        @CustomType.Setter
        public Builder action(@Nullable WebAclRuleAction action) {
            this.action = action;
            return this;
        }
        @CustomType.Setter
        public Builder captchaConfig(@Nullable WebAclRuleCaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }
        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }
        @CustomType.Setter
        public Builder overrideAction(@Nullable WebAclRuleOverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }
        @CustomType.Setter
        public Builder priority(Integer priority) {
            this.priority = Objects.requireNonNull(priority);
            return this;
        }
        @CustomType.Setter
        public Builder ruleLabels(@Nullable List<WebAclRuleRuleLabel> ruleLabels) {
            this.ruleLabels = ruleLabels;
            return this;
        }
        public Builder ruleLabels(WebAclRuleRuleLabel... ruleLabels) {
            return ruleLabels(List.of(ruleLabels));
        }
        @CustomType.Setter
        public Builder statement(WebAclRuleStatement statement) {
            this.statement = Objects.requireNonNull(statement);
            return this;
        }
        @CustomType.Setter
        public Builder visibilityConfig(WebAclRuleVisibilityConfig visibilityConfig) {
            this.visibilityConfig = Objects.requireNonNull(visibilityConfig);
            return this;
        }
        public WebAclRule build() {
            final var o = new WebAclRule();
            o.action = action;
            o.captchaConfig = captchaConfig;
            o.name = name;
            o.overrideAction = overrideAction;
            o.priority = priority;
            o.ruleLabels = ruleLabels;
            o.statement = statement;
            o.visibilityConfig = visibilityConfig;
            return o;
        }
    }
}
