// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.wafv2.outputs;

import com.pulumi.aws.wafv2.outputs.RuleGroupRuleAction;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleCaptchaConfig;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleRuleLabel;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatement;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleVisibilityConfig;
import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RuleGroupRule {
    /**
     * @return The action that AWS WAF should take on a web request when it matches the rule&#39;s statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
     * 
     */
    private RuleGroupRuleAction action;
    /**
     * @return Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
     * 
     */
    private @Nullable RuleGroupRuleCaptchaConfig captchaConfig;
    /**
     * @return A friendly name of the rule.
     * 
     */
    private String name;
    /**
     * @return If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     * 
     */
    private Integer priority;
    /**
     * @return Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     * 
     */
    private @Nullable List<RuleGroupRuleRuleLabel> ruleLabels;
    /**
     * @return The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
     * 
     */
    private RuleGroupRuleStatement statement;
    /**
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     * 
     */
    private RuleGroupRuleVisibilityConfig visibilityConfig;

    private RuleGroupRule() {}
    /**
     * @return The action that AWS WAF should take on a web request when it matches the rule&#39;s statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
     * 
     */
    public RuleGroupRuleAction action() {
        return this.action;
    }
    /**
     * @return Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
     * 
     */
    public Optional<RuleGroupRuleCaptchaConfig> captchaConfig() {
        return Optional.ofNullable(this.captchaConfig);
    }
    /**
     * @return A friendly name of the rule.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     * 
     */
    public Integer priority() {
        return this.priority;
    }
    /**
     * @return Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     * 
     */
    public List<RuleGroupRuleRuleLabel> ruleLabels() {
        return this.ruleLabels == null ? List.of() : this.ruleLabels;
    }
    /**
     * @return The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
     * 
     */
    public RuleGroupRuleStatement statement() {
        return this.statement;
    }
    /**
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     * 
     */
    public RuleGroupRuleVisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuleGroupRule defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private RuleGroupRuleAction action;
        private @Nullable RuleGroupRuleCaptchaConfig captchaConfig;
        private String name;
        private Integer priority;
        private @Nullable List<RuleGroupRuleRuleLabel> ruleLabels;
        private RuleGroupRuleStatement statement;
        private RuleGroupRuleVisibilityConfig visibilityConfig;
        public Builder() {}
        public Builder(RuleGroupRule defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.action = defaults.action;
    	      this.captchaConfig = defaults.captchaConfig;
    	      this.name = defaults.name;
    	      this.priority = defaults.priority;
    	      this.ruleLabels = defaults.ruleLabels;
    	      this.statement = defaults.statement;
    	      this.visibilityConfig = defaults.visibilityConfig;
        }

        @CustomType.Setter
        public Builder action(RuleGroupRuleAction action) {
            this.action = Objects.requireNonNull(action);
            return this;
        }
        @CustomType.Setter
        public Builder captchaConfig(@Nullable RuleGroupRuleCaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }
        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }
        @CustomType.Setter
        public Builder priority(Integer priority) {
            this.priority = Objects.requireNonNull(priority);
            return this;
        }
        @CustomType.Setter
        public Builder ruleLabels(@Nullable List<RuleGroupRuleRuleLabel> ruleLabels) {
            this.ruleLabels = ruleLabels;
            return this;
        }
        public Builder ruleLabels(RuleGroupRuleRuleLabel... ruleLabels) {
            return ruleLabels(List.of(ruleLabels));
        }
        @CustomType.Setter
        public Builder statement(RuleGroupRuleStatement statement) {
            this.statement = Objects.requireNonNull(statement);
            return this;
        }
        @CustomType.Setter
        public Builder visibilityConfig(RuleGroupRuleVisibilityConfig visibilityConfig) {
            this.visibilityConfig = Objects.requireNonNull(visibilityConfig);
            return this;
        }
        public RuleGroupRule build() {
            final var o = new RuleGroupRule();
            o.action = action;
            o.captchaConfig = captchaConfig;
            o.name = name;
            o.priority = priority;
            o.ruleLabels = ruleLabels;
            o.statement = statement;
            o.visibilityConfig = visibilityConfig;
            return o;
        }
    }
}
