// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.wafv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationState;
import com.pulumi.aws.wafv2.outputs.WebAclLoggingConfigurationLoggingFilter;
import com.pulumi.aws.wafv2.outputs.WebAclLoggingConfigurationRedactedField;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * This resource creates a WAFv2 Web ACL Logging Configuration.
 * 
 * !&gt; **WARNING:** When logging from a WAFv2 Web ACL to a CloudWatch Log Group, the WAFv2 service tries to create or update a generic Log Resource Policy named `AWSWAF-LOGS`. However, if there are a large number of Web ACLs or if the account frequently creates and deletes Web ACLs, this policy may exceed the maximum policy size. As a result, this resource type will fail to be created. More details about this issue can be found in this issue. To prevent this issue, you can manage a specific resource policy. Please refer to the example below for managing a CloudWatch Log Group with a managed CloudWatch Log Resource Policy.
 * 
 * ## Example Usage
 * ### With Redacted Fields
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration(&#34;example&#34;, WebAclLoggingConfigurationArgs.builder()        
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .redactedFields(WebAclLoggingConfigurationRedactedFieldArgs.builder()
 *                 .singleHeader(WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs.builder()
 *                     .name(&#34;user-agent&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With Logging Filter
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration(&#34;example&#34;, WebAclLoggingConfigurationArgs.builder()        
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .loggingFilter(WebAclLoggingConfigurationLoggingFilterArgs.builder()
 *                 .defaultBehavior(&#34;KEEP&#34;)
 *                 .filters(                
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior(&#34;DROP&#34;)
 *                         .conditions(                        
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                     .action(&#34;COUNT&#34;)
 *                                     .build())
 *                                 .build(),
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .labelNameCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs.builder()
 *                                     .labelName(&#34;awswaf:111122223333:rulegroup:testRules:LabelNameZ&#34;)
 *                                     .build())
 *                                 .build())
 *                         .requirement(&#34;MEETS_ALL&#34;)
 *                         .build(),
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior(&#34;KEEP&#34;)
 *                         .conditions(WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                             .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                 .action(&#34;ALLOW&#34;)
 *                                 .build())
 *                             .build())
 *                         .requirement(&#34;MEETS_ANY&#34;)
 *                         .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import WAFv2 Web ACL Logging Configurations using the ARN of the WAFv2 Web ACL. For example:
 * 
 * ```sh
 *  $ pulumi import aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration example arn:aws:wafv2:us-west-2:123456789012:regional/webacl/test-logs/a1b2c3d4-5678-90ab-cdef
 * ```
 * 
 */
@ResourceType(type="aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration")
public class WebAclLoggingConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     * 
     */
    @Export(name="logDestinationConfigs", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> logDestinationConfigs;

    /**
     * @return Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     * 
     */
    public Output<List<String>> logDestinationConfigs() {
        return this.logDestinationConfigs;
    }
    /**
     * Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     * 
     */
    @Export(name="loggingFilter", refs={WebAclLoggingConfigurationLoggingFilter.class}, tree="[0]")
    private Output</* @Nullable */ WebAclLoggingConfigurationLoggingFilter> loggingFilter;

    /**
     * @return Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     * 
     */
    public Output<Optional<WebAclLoggingConfigurationLoggingFilter>> loggingFilter() {
        return Codegen.optional(this.loggingFilter);
    }
    /**
     * Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     * 
     */
    @Export(name="redactedFields", refs={List.class,WebAclLoggingConfigurationRedactedField.class}, tree="[0,1]")
    private Output</* @Nullable */ List<WebAclLoggingConfigurationRedactedField>> redactedFields;

    /**
     * @return Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     * 
     */
    public Output<Optional<List<WebAclLoggingConfigurationRedactedField>>> redactedFields() {
        return Codegen.optional(this.redactedFields);
    }
    /**
     * Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
     * 
     */
    @Export(name="resourceArn", refs={String.class}, tree="[0]")
    private Output<String> resourceArn;

    /**
     * @return Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public WebAclLoggingConfiguration(String name) {
        this(name, WebAclLoggingConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public WebAclLoggingConfiguration(String name, WebAclLoggingConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public WebAclLoggingConfiguration(String name, WebAclLoggingConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration", name, args == null ? WebAclLoggingConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private WebAclLoggingConfiguration(String name, Output<String> id, @Nullable WebAclLoggingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static WebAclLoggingConfiguration get(String name, Output<String> id, @Nullable WebAclLoggingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new WebAclLoggingConfiguration(name, id, state, options);
    }
}
