// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.vpclattice;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.vpclattice.ListenerRuleArgs;
import com.pulumi.aws.vpclattice.inputs.ListenerRuleState;
import com.pulumi.aws.vpclattice.outputs.ListenerRuleAction;
import com.pulumi.aws.vpclattice.outputs.ListenerRuleMatch;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS VPC Lattice Listener Rule.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule(&#34;test&#34;, ListenerRuleArgs.builder()        
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(20)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .headerMatches(ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
 *                         .name(&#34;example-header&#34;)
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
 *                             .exact(&#34;example-contains&#34;)
 *                             .build())
 *                         .build())
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(true)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .prefix(&#34;/example-path&#34;)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(                    
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example().id())
 *                             .weight(1)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example2().id())
 *                             .weight(2)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule(&#34;test&#34;, ListenerRuleArgs.builder()        
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(10)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .exact(&#34;/example-path&#34;)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPC Lattice Listener Rule using the `example_id_arg`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:vpclattice/listenerRule:ListenerRule example rft-8012925589
 * ```
 * 
 */
@ResourceType(type="aws:vpclattice/listenerRule:ListenerRule")
public class ListenerRule extends com.pulumi.resources.CustomResource {
    /**
     * The action for the default rule.
     * 
     */
    @Export(name="action", refs={ListenerRuleAction.class}, tree="[0]")
    private Output<ListenerRuleAction> action;

    /**
     * @return The action for the default rule.
     * 
     */
    public Output<ListenerRuleAction> action() {
        return this.action;
    }
    /**
     * ARN of the target group.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the target group.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The ID or Amazon Resource Name (ARN) of the listener.
     * 
     */
    @Export(name="listenerIdentifier", refs={String.class}, tree="[0]")
    private Output<String> listenerIdentifier;

    /**
     * @return The ID or Amazon Resource Name (ARN) of the listener.
     * 
     */
    public Output<String> listenerIdentifier() {
        return this.listenerIdentifier;
    }
    /**
     * The rule match.
     * 
     */
    @Export(name="match", refs={ListenerRuleMatch.class}, tree="[0]")
    private Output<ListenerRuleMatch> match;

    /**
     * @return The rule match.
     * 
     */
    public Output<ListenerRuleMatch> match() {
        return this.match;
    }
    /**
     * The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can&#39;t use a hyphen as the first or last character, or immediately after another hyphen.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can&#39;t use a hyphen as the first or last character, or immediately after another hyphen.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="priority", refs={Integer.class}, tree="[0]")
    private Output<Integer> priority;

    /**
     * @return The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Integer> priority() {
        return this.priority;
    }
    /**
     * Unique identifier for the target group.
     * 
     */
    @Export(name="ruleId", refs={String.class}, tree="[0]")
    private Output<String> ruleId;

    /**
     * @return Unique identifier for the target group.
     * 
     */
    public Output<String> ruleId() {
        return this.ruleId;
    }
    /**
     * The ID or Amazon Resource Identifier (ARN) of the service.
     * 
     */
    @Export(name="serviceIdentifier", refs={String.class}, tree="[0]")
    private Output<String> serviceIdentifier;

    /**
     * @return The ID or Amazon Resource Identifier (ARN) of the service.
     * 
     */
    public Output<String> serviceIdentifier() {
        return this.serviceIdentifier;
    }
    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ListenerRule(String name) {
        this(name, ListenerRuleArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ListenerRule(String name, ListenerRuleArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ListenerRule(String name, ListenerRuleArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/listenerRule:ListenerRule", name, args == null ? ListenerRuleArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ListenerRule(String name, Output<String> id, @Nullable ListenerRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/listenerRule:ListenerRule", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ListenerRule get(String name, Output<String> id, @Nullable ListenerRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ListenerRule(name, id, state, options);
    }
}
