// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.vpclattice;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AuthPolicyArgs extends com.pulumi.resources.ResourceArgs {

    public static final AuthPolicyArgs Empty = new AuthPolicyArgs();

    /**
     * The auth policy. The policy string in JSON must not contain newlines or blank lines.
     * 
     */
    @Import(name="policy", required=true)
    private Output<String> policy;

    /**
     * @return The auth policy. The policy string in JSON must not contain newlines or blank lines.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }

    /**
     * The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     * 
     */
    @Import(name="resourceIdentifier", required=true)
    private Output<String> resourceIdentifier;

    /**
     * @return The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     * 
     */
    public Output<String> resourceIdentifier() {
        return this.resourceIdentifier;
    }

    /**
     * The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     * 
     */
    @Import(name="state")
    private @Nullable Output<String> state;

    /**
     * @return The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     * 
     */
    public Optional<Output<String>> state() {
        return Optional.ofNullable(this.state);
    }

    private AuthPolicyArgs() {}

    private AuthPolicyArgs(AuthPolicyArgs $) {
        this.policy = $.policy;
        this.resourceIdentifier = $.resourceIdentifier;
        this.state = $.state;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AuthPolicyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AuthPolicyArgs $;

        public Builder() {
            $ = new AuthPolicyArgs();
        }

        public Builder(AuthPolicyArgs defaults) {
            $ = new AuthPolicyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
         * 
         * @return builder
         * 
         */
        public Builder policy(Output<String> policy) {
            $.policy = policy;
            return this;
        }

        /**
         * @param policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
         * 
         * @return builder
         * 
         */
        public Builder policy(String policy) {
            return policy(Output.of(policy));
        }

        /**
         * @param resourceIdentifier The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
         * 
         * @return builder
         * 
         */
        public Builder resourceIdentifier(Output<String> resourceIdentifier) {
            $.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * @param resourceIdentifier The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
         * 
         * @return builder
         * 
         */
        public Builder resourceIdentifier(String resourceIdentifier) {
            return resourceIdentifier(Output.of(resourceIdentifier));
        }

        /**
         * @param state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
         * 
         * @return builder
         * 
         */
        public Builder state(@Nullable Output<String> state) {
            $.state = state;
            return this;
        }

        /**
         * @param state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
         * 
         * @return builder
         * 
         */
        public Builder state(String state) {
            return state(Output.of(state));
        }

        public AuthPolicyArgs build() {
            $.policy = Objects.requireNonNull($.policy, "expected parameter 'policy' to be non-null");
            $.resourceIdentifier = Objects.requireNonNull($.resourceIdentifier, "expected parameter 'resourceIdentifier' to be non-null");
            return $;
        }
    }

}
