// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.vpclattice;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.vpclattice.AuthPolicyArgs;
import com.pulumi.aws.vpclattice.inputs.AuthPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS VPC Lattice Auth Policy.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.AuthPolicy;
 * import com.pulumi.aws.vpclattice.AuthPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleService = new Service(&#34;exampleService&#34;, ServiceArgs.builder()        
 *             .authType(&#34;AWS_IAM&#34;)
 *             .customDomainName(&#34;example.com&#34;)
 *             .build());
 * 
 *         var exampleAuthPolicy = new AuthPolicy(&#34;exampleAuthPolicy&#34;, AuthPolicyArgs.builder()        
 *             .resourceIdentifier(exampleService.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                     jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;Action&#34;, &#34;*&#34;),
 *                         jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                         jsonProperty(&#34;Principal&#34;, &#34;*&#34;),
 *                         jsonProperty(&#34;Resource&#34;, &#34;*&#34;),
 *                         jsonProperty(&#34;Condition&#34;, jsonObject(
 *                             jsonProperty(&#34;StringNotEqualsIgnoreCase&#34;, jsonObject(
 *                                 jsonProperty(&#34;aws:PrincipalType&#34;, &#34;anonymous&#34;)
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPC Lattice Auth Policy using the `example_id_arg`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:vpclattice/authPolicy:AuthPolicy example rft-8012925589
 * ```
 * 
 */
@ResourceType(type="aws:vpclattice/authPolicy:AuthPolicy")
public class AuthPolicy extends com.pulumi.resources.CustomResource {
    /**
     * The auth policy. The policy string in JSON must not contain newlines or blank lines.
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output<String> policy;

    /**
     * @return The auth policy. The policy string in JSON must not contain newlines or blank lines.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }
    /**
     * The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     * 
     */
    @Export(name="resourceIdentifier", refs={String.class}, tree="[0]")
    private Output<String> resourceIdentifier;

    /**
     * @return The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     * 
     */
    public Output<String> resourceIdentifier() {
        return this.resourceIdentifier;
    }
    /**
     * The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     * 
     */
    @Export(name="state", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> state;

    /**
     * @return The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client&#39;s IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     * 
     */
    public Output<Optional<String>> state() {
        return Codegen.optional(this.state);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AuthPolicy(String name) {
        this(name, AuthPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AuthPolicy(String name, AuthPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AuthPolicy(String name, AuthPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/authPolicy:AuthPolicy", name, args == null ? AuthPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AuthPolicy(String name, Output<String> id, @Nullable AuthPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/authPolicy:AuthPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AuthPolicy get(String name, Output<String> id, @Nullable AuthPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AuthPolicy(name, id, state, options);
    }
}
