// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.vpclattice;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs;
import com.pulumi.aws.vpclattice.inputs.AccessLogSubscriptionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS VPC Lattice Service Network or Service Access log subscription.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.AccessLogSubscription;
 * import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AccessLogSubscription(&#34;example&#34;, AccessLogSubscriptionArgs.builder()        
 *             .resourceIdentifier(aws_vpclattice_service_network.example().id())
 *             .destinationArn(aws_s3.bucket().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPC Lattice Access Log Subscription using the access log subscription ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:vpclattice/accessLogSubscription:AccessLogSubscription example rft-8012925589
 * ```
 * 
 */
@ResourceType(type="aws:vpclattice/accessLogSubscription:AccessLogSubscription")
public class AccessLogSubscription extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the access log subscription.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the access log subscription.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Amazon Resource Name (ARN) of the log destination.
     * 
     */
    @Export(name="destinationArn", refs={String.class}, tree="[0]")
    private Output<String> destinationArn;

    /**
     * @return Amazon Resource Name (ARN) of the log destination.
     * 
     */
    public Output<String> destinationArn() {
        return this.destinationArn;
    }
    /**
     * Amazon Resource Name (ARN) of the service network or service.
     * 
     */
    @Export(name="resourceArn", refs={String.class}, tree="[0]")
    private Output<String> resourceArn;

    /**
     * @return Amazon Resource Name (ARN) of the service network or service.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }
    /**
     * The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     * 
     */
    @Export(name="resourceIdentifier", refs={String.class}, tree="[0]")
    private Output<String> resourceIdentifier;

    /**
     * @return The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     * 
     */
    public Output<String> resourceIdentifier() {
        return this.resourceIdentifier;
    }
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AccessLogSubscription(String name) {
        this(name, AccessLogSubscriptionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AccessLogSubscription(String name, AccessLogSubscriptionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AccessLogSubscription(String name, AccessLogSubscriptionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/accessLogSubscription:AccessLogSubscription", name, args == null ? AccessLogSubscriptionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AccessLogSubscription(String name, Output<String> id, @Nullable AccessLogSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpclattice/accessLogSubscription:AccessLogSubscription", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AccessLogSubscription get(String name, Output<String> id, @Nullable AccessLogSubscriptionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AccessLogSubscription(name, id, state, options);
    }
}
