// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.vpc;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs;
import com.pulumi.aws.vpc.inputs.SecurityGroupIngressRuleState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an inbound (ingress) rule for a security group.
 * 
 * When specifying an inbound rule for your security group in a VPC, the configuration must include a source for the traffic.
 * 
 * &gt; **NOTE on Security Groups and Security Group Rules:** this provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or
 * `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID.
 * The `aws.vpc.SecurityGroupIngressRule` resource has been added to address these limitations and should be used for all new security group rules.
 * You should not use the `aws.vpc.SecurityGroupIngressRule` resource in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRule;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroupIngressRule(&#34;example&#34;, SecurityGroupIngressRuleArgs.builder()        
 *             .securityGroupId(aws_security_group.example().id())
 *             .cidrIpv4(&#34;10.0.0.0/8&#34;)
 *             .fromPort(80)
 *             .ipProtocol(&#34;tcp&#34;)
 *             .toPort(80)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import security group ingress rules using the `security_group_rule_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule example sgr-02108b27edd666983
 * ```
 * 
 */
@ResourceType(type="aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule")
public class SecurityGroupIngressRule extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the security group rule.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the security group rule.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The source IPv4 CIDR range.
     * 
     */
    @Export(name="cidrIpv4", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cidrIpv4;

    /**
     * @return The source IPv4 CIDR range.
     * 
     */
    public Output<Optional<String>> cidrIpv4() {
        return Codegen.optional(this.cidrIpv4);
    }
    /**
     * The source IPv6 CIDR range.
     * 
     */
    @Export(name="cidrIpv6", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cidrIpv6;

    /**
     * @return The source IPv6 CIDR range.
     * 
     */
    public Output<Optional<String>> cidrIpv6() {
        return Codegen.optional(this.cidrIpv6);
    }
    /**
     * The security group rule description.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The security group rule description.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     * 
     */
    @Export(name="fromPort", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> fromPort;

    /**
     * @return The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     * 
     */
    public Output<Optional<Integer>> fromPort() {
        return Codegen.optional(this.fromPort);
    }
    /**
     * The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     * 
     */
    @Export(name="ipProtocol", refs={String.class}, tree="[0]")
    private Output<String> ipProtocol;

    /**
     * @return The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     * 
     */
    public Output<String> ipProtocol() {
        return this.ipProtocol;
    }
    /**
     * The ID of the source prefix list.
     * 
     */
    @Export(name="prefixListId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> prefixListId;

    /**
     * @return The ID of the source prefix list.
     * 
     */
    public Output<Optional<String>> prefixListId() {
        return Codegen.optional(this.prefixListId);
    }
    /**
     * The source security group that is referenced in the rule.
     * 
     */
    @Export(name="referencedSecurityGroupId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> referencedSecurityGroupId;

    /**
     * @return The source security group that is referenced in the rule.
     * 
     */
    public Output<Optional<String>> referencedSecurityGroupId() {
        return Codegen.optional(this.referencedSecurityGroupId);
    }
    /**
     * The ID of the security group.
     * 
     */
    @Export(name="securityGroupId", refs={String.class}, tree="[0]")
    private Output<String> securityGroupId;

    /**
     * @return The ID of the security group.
     * 
     */
    public Output<String> securityGroupId() {
        return this.securityGroupId;
    }
    /**
     * The ID of the security group rule.
     * 
     */
    @Export(name="securityGroupRuleId", refs={String.class}, tree="[0]")
    private Output<String> securityGroupRuleId;

    /**
     * @return The ID of the security group rule.
     * 
     */
    public Output<String> securityGroupRuleId() {
        return this.securityGroupRuleId;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * 
     */
    @Export(name="toPort", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> toPort;

    /**
     * @return The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * 
     */
    public Output<Optional<Integer>> toPort() {
        return Codegen.optional(this.toPort);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SecurityGroupIngressRule(String name) {
        this(name, SecurityGroupIngressRuleArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SecurityGroupIngressRule(String name, SecurityGroupIngressRuleArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SecurityGroupIngressRule(String name, SecurityGroupIngressRuleArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule", name, args == null ? SecurityGroupIngressRuleArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SecurityGroupIngressRule(String name, Output<String> id, @Nullable SecurityGroupIngressRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SecurityGroupIngressRule get(String name, Output<String> id, @Nullable SecurityGroupIngressRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SecurityGroupIngressRule(name, id, state, options);
    }
}
