// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.verifiedaccess;

import com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs;
import com.pulumi.aws.verifiedaccess.inputs.TrustProviderOidcOptionsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TrustProviderArgs extends com.pulumi.resources.ResourceArgs {

    public static final TrustProviderArgs Empty = new TrustProviderArgs();

    /**
     * A description for the AWS Verified Access trust provider.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description for the AWS Verified Access trust provider.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A block of options for device identity based trust providers.
     * 
     */
    @Import(name="deviceOptions")
    private @Nullable Output<TrustProviderDeviceOptionsArgs> deviceOptions;

    /**
     * @return A block of options for device identity based trust providers.
     * 
     */
    public Optional<Output<TrustProviderDeviceOptionsArgs>> deviceOptions() {
        return Optional.ofNullable(this.deviceOptions);
    }

    /**
     * The type of device-based trust provider.
     * 
     */
    @Import(name="deviceTrustProviderType")
    private @Nullable Output<String> deviceTrustProviderType;

    /**
     * @return The type of device-based trust provider.
     * 
     */
    public Optional<Output<String>> deviceTrustProviderType() {
        return Optional.ofNullable(this.deviceTrustProviderType);
    }

    /**
     * The OpenID Connect details for an oidc-type, user-identity based trust provider.
     * 
     */
    @Import(name="oidcOptions")
    private @Nullable Output<TrustProviderOidcOptionsArgs> oidcOptions;

    /**
     * @return The OpenID Connect details for an oidc-type, user-identity based trust provider.
     * 
     */
    public Optional<Output<TrustProviderOidcOptionsArgs>> oidcOptions() {
        return Optional.ofNullable(this.oidcOptions);
    }

    /**
     * The identifier to be used when working with policy rules.
     * 
     */
    @Import(name="policyReferenceName", required=true)
    private Output<String> policyReferenceName;

    /**
     * @return The identifier to be used when working with policy rules.
     * 
     */
    public Output<String> policyReferenceName() {
        return this.policyReferenceName;
    }

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The type of trust provider can be either user or device-based.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="trustProviderType", required=true)
    private Output<String> trustProviderType;

    /**
     * @return The type of trust provider can be either user or device-based.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> trustProviderType() {
        return this.trustProviderType;
    }

    /**
     * The type of user-based trust provider.
     * 
     */
    @Import(name="userTrustProviderType")
    private @Nullable Output<String> userTrustProviderType;

    /**
     * @return The type of user-based trust provider.
     * 
     */
    public Optional<Output<String>> userTrustProviderType() {
        return Optional.ofNullable(this.userTrustProviderType);
    }

    private TrustProviderArgs() {}

    private TrustProviderArgs(TrustProviderArgs $) {
        this.description = $.description;
        this.deviceOptions = $.deviceOptions;
        this.deviceTrustProviderType = $.deviceTrustProviderType;
        this.oidcOptions = $.oidcOptions;
        this.policyReferenceName = $.policyReferenceName;
        this.tags = $.tags;
        this.trustProviderType = $.trustProviderType;
        this.userTrustProviderType = $.userTrustProviderType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TrustProviderArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TrustProviderArgs $;

        public Builder() {
            $ = new TrustProviderArgs();
        }

        public Builder(TrustProviderArgs defaults) {
            $ = new TrustProviderArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A description for the AWS Verified Access trust provider.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description for the AWS Verified Access trust provider.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param deviceOptions A block of options for device identity based trust providers.
         * 
         * @return builder
         * 
         */
        public Builder deviceOptions(@Nullable Output<TrustProviderDeviceOptionsArgs> deviceOptions) {
            $.deviceOptions = deviceOptions;
            return this;
        }

        /**
         * @param deviceOptions A block of options for device identity based trust providers.
         * 
         * @return builder
         * 
         */
        public Builder deviceOptions(TrustProviderDeviceOptionsArgs deviceOptions) {
            return deviceOptions(Output.of(deviceOptions));
        }

        /**
         * @param deviceTrustProviderType The type of device-based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder deviceTrustProviderType(@Nullable Output<String> deviceTrustProviderType) {
            $.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        /**
         * @param deviceTrustProviderType The type of device-based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder deviceTrustProviderType(String deviceTrustProviderType) {
            return deviceTrustProviderType(Output.of(deviceTrustProviderType));
        }

        /**
         * @param oidcOptions The OpenID Connect details for an oidc-type, user-identity based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder oidcOptions(@Nullable Output<TrustProviderOidcOptionsArgs> oidcOptions) {
            $.oidcOptions = oidcOptions;
            return this;
        }

        /**
         * @param oidcOptions The OpenID Connect details for an oidc-type, user-identity based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder oidcOptions(TrustProviderOidcOptionsArgs oidcOptions) {
            return oidcOptions(Output.of(oidcOptions));
        }

        /**
         * @param policyReferenceName The identifier to be used when working with policy rules.
         * 
         * @return builder
         * 
         */
        public Builder policyReferenceName(Output<String> policyReferenceName) {
            $.policyReferenceName = policyReferenceName;
            return this;
        }

        /**
         * @param policyReferenceName The identifier to be used when working with policy rules.
         * 
         * @return builder
         * 
         */
        public Builder policyReferenceName(String policyReferenceName) {
            return policyReferenceName(Output.of(policyReferenceName));
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param trustProviderType The type of trust provider can be either user or device-based.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder trustProviderType(Output<String> trustProviderType) {
            $.trustProviderType = trustProviderType;
            return this;
        }

        /**
         * @param trustProviderType The type of trust provider can be either user or device-based.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder trustProviderType(String trustProviderType) {
            return trustProviderType(Output.of(trustProviderType));
        }

        /**
         * @param userTrustProviderType The type of user-based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder userTrustProviderType(@Nullable Output<String> userTrustProviderType) {
            $.userTrustProviderType = userTrustProviderType;
            return this;
        }

        /**
         * @param userTrustProviderType The type of user-based trust provider.
         * 
         * @return builder
         * 
         */
        public Builder userTrustProviderType(String userTrustProviderType) {
            return userTrustProviderType(Output.of(userTrustProviderType));
        }

        public TrustProviderArgs build() {
            $.policyReferenceName = Objects.requireNonNull($.policyReferenceName, "expected parameter 'policyReferenceName' to be non-null");
            $.trustProviderType = Objects.requireNonNull($.trustProviderType, "expected parameter 'trustProviderType' to be non-null");
            return $;
        }
    }

}
