// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.verifiedaccess;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
import com.pulumi.aws.verifiedaccess.inputs.TrustProviderState;
import com.pulumi.aws.verifiedaccess.outputs.TrustProviderDeviceOptions;
import com.pulumi.aws.verifiedaccess.outputs.TrustProviderOidcOptions;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing a Verified Access Trust Provider.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new TrustProvider(&#34;example&#34;, TrustProviderArgs.builder()        
 *             .policyReferenceName(&#34;example&#34;)
 *             .trustProviderType(&#34;user&#34;)
 *             .userTrustProviderType(&#34;iam-identity-center&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Transfer Workflows using the `id`. For exampleterraform import {
 * 
 *  to = aws_verifiedaccess_trust_provider.example
 * 
 *  id = &#34;vatp-8012925589&#34; } Using `TODO import`, import Transfer Workflows using the
 * 
 * `id`. For exampleconsole % TODO import aws_verifiedaccess_trust_provider.example vatp-8012925589
 * 
 */
@ResourceType(type="aws:verifiedaccess/trustProvider:TrustProvider")
public class TrustProvider extends com.pulumi.resources.CustomResource {
    /**
     * A description for the AWS Verified Access trust provider.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description for the AWS Verified Access trust provider.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * A block of options for device identity based trust providers.
     * 
     */
    @Export(name="deviceOptions", refs={TrustProviderDeviceOptions.class}, tree="[0]")
    private Output</* @Nullable */ TrustProviderDeviceOptions> deviceOptions;

    /**
     * @return A block of options for device identity based trust providers.
     * 
     */
    public Output<Optional<TrustProviderDeviceOptions>> deviceOptions() {
        return Codegen.optional(this.deviceOptions);
    }
    /**
     * The type of device-based trust provider.
     * 
     */
    @Export(name="deviceTrustProviderType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> deviceTrustProviderType;

    /**
     * @return The type of device-based trust provider.
     * 
     */
    public Output<Optional<String>> deviceTrustProviderType() {
        return Codegen.optional(this.deviceTrustProviderType);
    }
    /**
     * The OpenID Connect details for an oidc-type, user-identity based trust provider.
     * 
     */
    @Export(name="oidcOptions", refs={TrustProviderOidcOptions.class}, tree="[0]")
    private Output</* @Nullable */ TrustProviderOidcOptions> oidcOptions;

    /**
     * @return The OpenID Connect details for an oidc-type, user-identity based trust provider.
     * 
     */
    public Output<Optional<TrustProviderOidcOptions>> oidcOptions() {
        return Codegen.optional(this.oidcOptions);
    }
    /**
     * The identifier to be used when working with policy rules.
     * 
     */
    @Export(name="policyReferenceName", refs={String.class}, tree="[0]")
    private Output<String> policyReferenceName;

    /**
     * @return The identifier to be used when working with policy rules.
     * 
     */
    public Output<String> policyReferenceName() {
        return this.policyReferenceName;
    }
    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The type of trust provider can be either user or device-based.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="trustProviderType", refs={String.class}, tree="[0]")
    private Output<String> trustProviderType;

    /**
     * @return The type of trust provider can be either user or device-based.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> trustProviderType() {
        return this.trustProviderType;
    }
    /**
     * The type of user-based trust provider.
     * 
     */
    @Export(name="userTrustProviderType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> userTrustProviderType;

    /**
     * @return The type of user-based trust provider.
     * 
     */
    public Output<Optional<String>> userTrustProviderType() {
        return Codegen.optional(this.userTrustProviderType);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TrustProvider(String name) {
        this(name, TrustProviderArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TrustProvider(String name, TrustProviderArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TrustProvider(String name, TrustProviderArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:verifiedaccess/trustProvider:TrustProvider", name, args == null ? TrustProviderArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TrustProvider(String name, Output<String> id, @Nullable TrustProviderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:verifiedaccess/trustProvider:TrustProvider", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TrustProvider get(String name, Output<String> id, @Nullable TrustProviderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TrustProvider(name, id, state, options);
    }
}
