// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.transfer.inputs;

import com.pulumi.aws.transfer.inputs.ServerEndpointDetailsArgs;
import com.pulumi.aws.transfer.inputs.ServerProtocolDetailsArgs;
import com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ServerState extends com.pulumi.resources.ResourceArgs {

    public static final ServerState Empty = new ServerState();

    /**
     * Amazon Resource Name (ARN) of Transfer Server
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of Transfer Server
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
     * 
     */
    @Import(name="certificate")
    private @Nullable Output<String> certificate;

    /**
     * @return The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
     * 
     */
    public Optional<Output<String>> certificate() {
        return Optional.ofNullable(this.certificate);
    }

    /**
     * The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
     * 
     */
    @Import(name="directoryId")
    private @Nullable Output<String> directoryId;

    /**
     * @return The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
     * 
     */
    public Optional<Output<String>> directoryId() {
        return Optional.ofNullable(this.directoryId);
    }

    /**
     * The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
     * 
     */
    @Import(name="domain")
    private @Nullable Output<String> domain;

    /**
     * @return The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
     * 
     */
    public Optional<Output<String>> domain() {
        return Optional.ofNullable(this.domain);
    }

    /**
     * The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     * 
     */
    @Import(name="endpointDetails")
    private @Nullable Output<ServerEndpointDetailsArgs> endpointDetails;

    /**
     * @return The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     * 
     */
    public Optional<Output<ServerEndpointDetailsArgs>> endpointDetails() {
        return Optional.ofNullable(this.endpointDetails);
    }

    /**
     * The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn&#39;t accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
     * 
     */
    @Import(name="endpointType")
    private @Nullable Output<String> endpointType;

    /**
     * @return The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn&#39;t accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
     * 
     */
    public Optional<Output<String>> endpointType() {
        return Optional.ofNullable(this.endpointType);
    }

    /**
     * A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
     * 
     */
    @Import(name="forceDestroy")
    private @Nullable Output<Boolean> forceDestroy;

    /**
     * @return A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
     * 
     */
    public Optional<Output<Boolean>> forceDestroy() {
        return Optional.ofNullable(this.forceDestroy);
    }

    /**
     * The ARN for a lambda function to use for the Identity provider.
     * 
     */
    @Import(name="function")
    private @Nullable Output<String> function;

    /**
     * @return The ARN for a lambda function to use for the Identity provider.
     * 
     */
    public Optional<Output<String>> function() {
        return Optional.ofNullable(this.function);
    }

    /**
     * RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N &#34;&#34; -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N &#34;&#34; -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N &#34;&#34; -f my-new-server-key` commands).
     * 
     */
    @Import(name="hostKey")
    private @Nullable Output<String> hostKey;

    /**
     * @return RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N &#34;&#34; -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N &#34;&#34; -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N &#34;&#34; -f my-new-server-key` commands).
     * 
     */
    public Optional<Output<String>> hostKey() {
        return Optional.ofNullable(this.hostKey);
    }

    /**
     * This value contains the message-digest algorithm (MD5) hash of the server&#39;s host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
     * 
     */
    @Import(name="hostKeyFingerprint")
    private @Nullable Output<String> hostKeyFingerprint;

    /**
     * @return This value contains the message-digest algorithm (MD5) hash of the server&#39;s host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
     * 
     */
    public Optional<Output<String>> hostKeyFingerprint() {
        return Optional.ofNullable(this.hostKeyFingerprint);
    }

    /**
     * The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
     * 
     */
    @Import(name="identityProviderType")
    private @Nullable Output<String> identityProviderType;

    /**
     * @return The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
     * 
     */
    public Optional<Output<String>> identityProviderType() {
        return Optional.ofNullable(this.identityProviderType);
    }

    /**
     * Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
     * 
     */
    @Import(name="invocationRole")
    private @Nullable Output<String> invocationRole;

    /**
     * @return Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
     * 
     */
    public Optional<Output<String>> invocationRole() {
        return Optional.ofNullable(this.invocationRole);
    }

    /**
     * Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
     * 
     */
    @Import(name="loggingRole")
    private @Nullable Output<String> loggingRole;

    /**
     * @return Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
     * 
     */
    public Optional<Output<String>> loggingRole() {
        return Optional.ofNullable(this.loggingRole);
    }

    /**
     * Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
     * 
     */
    @Import(name="postAuthenticationLoginBanner")
    private @Nullable Output<String> postAuthenticationLoginBanner;

    /**
     * @return Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
     * 
     */
    public Optional<Output<String>> postAuthenticationLoginBanner() {
        return Optional.ofNullable(this.postAuthenticationLoginBanner);
    }

    /**
     * Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
     * 
     */
    @Import(name="preAuthenticationLoginBanner")
    private @Nullable Output<String> preAuthenticationLoginBanner;

    /**
     * @return Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
     * 
     */
    public Optional<Output<String>> preAuthenticationLoginBanner() {
        return Optional.ofNullable(this.preAuthenticationLoginBanner);
    }

    /**
     * The protocol settings that are configured for your server.
     * 
     */
    @Import(name="protocolDetails")
    private @Nullable Output<ServerProtocolDetailsArgs> protocolDetails;

    /**
     * @return The protocol settings that are configured for your server.
     * 
     */
    public Optional<Output<ServerProtocolDetailsArgs>> protocolDetails() {
        return Optional.ofNullable(this.protocolDetails);
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server&#39;s endpoint. This defaults to `SFTP` . The available protocols are:
     * 
     */
    @Import(name="protocols")
    private @Nullable Output<List<String>> protocols;

    /**
     * @return Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server&#39;s endpoint. This defaults to `SFTP` . The available protocols are:
     * 
     */
    public Optional<Output<List<String>>> protocols() {
        return Optional.ofNullable(this.protocols);
    }

    /**
     * Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
     * 
     */
    @Import(name="securityPolicyName")
    private @Nullable Output<String> securityPolicyName;

    /**
     * @return Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
     * 
     */
    public Optional<Output<String>> securityPolicyName() {
        return Optional.ofNullable(this.securityPolicyName);
    }

    /**
     * A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     * 
     */
    @Import(name="structuredLogDestinations")
    private @Nullable Output<List<String>> structuredLogDestinations;

    /**
     * @return A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     * 
     */
    public Optional<Output<List<String>>> structuredLogDestinations() {
        return Optional.ofNullable(this.structuredLogDestinations);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
     * 
     */
    @Import(name="url")
    private @Nullable Output<String> url;

    /**
     * @return URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
     * 
     */
    public Optional<Output<String>> url() {
        return Optional.ofNullable(this.url);
    }

    /**
     * Specifies the workflow details. See Workflow Details below.
     * 
     */
    @Import(name="workflowDetails")
    private @Nullable Output<ServerWorkflowDetailsArgs> workflowDetails;

    /**
     * @return Specifies the workflow details. See Workflow Details below.
     * 
     */
    public Optional<Output<ServerWorkflowDetailsArgs>> workflowDetails() {
        return Optional.ofNullable(this.workflowDetails);
    }

    private ServerState() {}

    private ServerState(ServerState $) {
        this.arn = $.arn;
        this.certificate = $.certificate;
        this.directoryId = $.directoryId;
        this.domain = $.domain;
        this.endpoint = $.endpoint;
        this.endpointDetails = $.endpointDetails;
        this.endpointType = $.endpointType;
        this.forceDestroy = $.forceDestroy;
        this.function = $.function;
        this.hostKey = $.hostKey;
        this.hostKeyFingerprint = $.hostKeyFingerprint;
        this.identityProviderType = $.identityProviderType;
        this.invocationRole = $.invocationRole;
        this.loggingRole = $.loggingRole;
        this.postAuthenticationLoginBanner = $.postAuthenticationLoginBanner;
        this.preAuthenticationLoginBanner = $.preAuthenticationLoginBanner;
        this.protocolDetails = $.protocolDetails;
        this.protocols = $.protocols;
        this.securityPolicyName = $.securityPolicyName;
        this.structuredLogDestinations = $.structuredLogDestinations;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.url = $.url;
        this.workflowDetails = $.workflowDetails;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ServerState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ServerState $;

        public Builder() {
            $ = new ServerState();
        }

        public Builder(ServerState defaults) {
            $ = new ServerState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of Transfer Server
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of Transfer Server
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
         * 
         * @return builder
         * 
         */
        public Builder certificate(@Nullable Output<String> certificate) {
            $.certificate = certificate;
            return this;
        }

        /**
         * @param certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
         * 
         * @return builder
         * 
         */
        public Builder certificate(String certificate) {
            return certificate(Output.of(certificate));
        }

        /**
         * @param directoryId The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
         * 
         * @return builder
         * 
         */
        public Builder directoryId(@Nullable Output<String> directoryId) {
            $.directoryId = directoryId;
            return this;
        }

        /**
         * @param directoryId The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
         * 
         * @return builder
         * 
         */
        public Builder directoryId(String directoryId) {
            return directoryId(Output.of(directoryId));
        }

        /**
         * @param domain The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
         * 
         * @return builder
         * 
         */
        public Builder domain(@Nullable Output<String> domain) {
            $.domain = domain;
            return this;
        }

        /**
         * @param domain The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
         * 
         * @return builder
         * 
         */
        public Builder domain(String domain) {
            return domain(Output.of(domain));
        }

        /**
         * @param endpoint The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder endpointDetails(@Nullable Output<ServerEndpointDetailsArgs> endpointDetails) {
            $.endpointDetails = endpointDetails;
            return this;
        }

        /**
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder endpointDetails(ServerEndpointDetailsArgs endpointDetails) {
            return endpointDetails(Output.of(endpointDetails));
        }

        /**
         * @param endpointType The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn&#39;t accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(@Nullable Output<String> endpointType) {
            $.endpointType = endpointType;
            return this;
        }

        /**
         * @param endpointType The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn&#39;t accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(String endpointType) {
            return endpointType(Output.of(endpointType));
        }

        /**
         * @param forceDestroy A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(@Nullable Output<Boolean> forceDestroy) {
            $.forceDestroy = forceDestroy;
            return this;
        }

        /**
         * @param forceDestroy A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(Boolean forceDestroy) {
            return forceDestroy(Output.of(forceDestroy));
        }

        /**
         * @param function The ARN for a lambda function to use for the Identity provider.
         * 
         * @return builder
         * 
         */
        public Builder function(@Nullable Output<String> function) {
            $.function = function;
            return this;
        }

        /**
         * @param function The ARN for a lambda function to use for the Identity provider.
         * 
         * @return builder
         * 
         */
        public Builder function(String function) {
            return function(Output.of(function));
        }

        /**
         * @param hostKey RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N &#34;&#34; -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N &#34;&#34; -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N &#34;&#34; -f my-new-server-key` commands).
         * 
         * @return builder
         * 
         */
        public Builder hostKey(@Nullable Output<String> hostKey) {
            $.hostKey = hostKey;
            return this;
        }

        /**
         * @param hostKey RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N &#34;&#34; -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N &#34;&#34; -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N &#34;&#34; -f my-new-server-key` commands).
         * 
         * @return builder
         * 
         */
        public Builder hostKey(String hostKey) {
            return hostKey(Output.of(hostKey));
        }

        /**
         * @param hostKeyFingerprint This value contains the message-digest algorithm (MD5) hash of the server&#39;s host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
         * 
         * @return builder
         * 
         */
        public Builder hostKeyFingerprint(@Nullable Output<String> hostKeyFingerprint) {
            $.hostKeyFingerprint = hostKeyFingerprint;
            return this;
        }

        /**
         * @param hostKeyFingerprint This value contains the message-digest algorithm (MD5) hash of the server&#39;s host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
         * 
         * @return builder
         * 
         */
        public Builder hostKeyFingerprint(String hostKeyFingerprint) {
            return hostKeyFingerprint(Output.of(hostKeyFingerprint));
        }

        /**
         * @param identityProviderType The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
         * 
         * @return builder
         * 
         */
        public Builder identityProviderType(@Nullable Output<String> identityProviderType) {
            $.identityProviderType = identityProviderType;
            return this;
        }

        /**
         * @param identityProviderType The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
         * 
         * @return builder
         * 
         */
        public Builder identityProviderType(String identityProviderType) {
            return identityProviderType(Output.of(identityProviderType));
        }

        /**
         * @param invocationRole Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
         * 
         * @return builder
         * 
         */
        public Builder invocationRole(@Nullable Output<String> invocationRole) {
            $.invocationRole = invocationRole;
            return this;
        }

        /**
         * @param invocationRole Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
         * 
         * @return builder
         * 
         */
        public Builder invocationRole(String invocationRole) {
            return invocationRole(Output.of(invocationRole));
        }

        /**
         * @param loggingRole Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
         * 
         * @return builder
         * 
         */
        public Builder loggingRole(@Nullable Output<String> loggingRole) {
            $.loggingRole = loggingRole;
            return this;
        }

        /**
         * @param loggingRole Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
         * 
         * @return builder
         * 
         */
        public Builder loggingRole(String loggingRole) {
            return loggingRole(Output.of(loggingRole));
        }

        /**
         * @param postAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
         * 
         * @return builder
         * 
         */
        public Builder postAuthenticationLoginBanner(@Nullable Output<String> postAuthenticationLoginBanner) {
            $.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
            return this;
        }

        /**
         * @param postAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
         * 
         * @return builder
         * 
         */
        public Builder postAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            return postAuthenticationLoginBanner(Output.of(postAuthenticationLoginBanner));
        }

        /**
         * @param preAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
         * 
         * @return builder
         * 
         */
        public Builder preAuthenticationLoginBanner(@Nullable Output<String> preAuthenticationLoginBanner) {
            $.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
            return this;
        }

        /**
         * @param preAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
         * 
         * @return builder
         * 
         */
        public Builder preAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            return preAuthenticationLoginBanner(Output.of(preAuthenticationLoginBanner));
        }

        /**
         * @param protocolDetails The protocol settings that are configured for your server.
         * 
         * @return builder
         * 
         */
        public Builder protocolDetails(@Nullable Output<ServerProtocolDetailsArgs> protocolDetails) {
            $.protocolDetails = protocolDetails;
            return this;
        }

        /**
         * @param protocolDetails The protocol settings that are configured for your server.
         * 
         * @return builder
         * 
         */
        public Builder protocolDetails(ServerProtocolDetailsArgs protocolDetails) {
            return protocolDetails(Output.of(protocolDetails));
        }

        /**
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server&#39;s endpoint. This defaults to `SFTP` . The available protocols are:
         * 
         * @return builder
         * 
         */
        public Builder protocols(@Nullable Output<List<String>> protocols) {
            $.protocols = protocols;
            return this;
        }

        /**
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server&#39;s endpoint. This defaults to `SFTP` . The available protocols are:
         * 
         * @return builder
         * 
         */
        public Builder protocols(List<String> protocols) {
            return protocols(Output.of(protocols));
        }

        /**
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server&#39;s endpoint. This defaults to `SFTP` . The available protocols are:
         * 
         * @return builder
         * 
         */
        public Builder protocols(String... protocols) {
            return protocols(List.of(protocols));
        }

        /**
         * @param securityPolicyName Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
         * 
         * @return builder
         * 
         */
        public Builder securityPolicyName(@Nullable Output<String> securityPolicyName) {
            $.securityPolicyName = securityPolicyName;
            return this;
        }

        /**
         * @param securityPolicyName Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
         * 
         * @return builder
         * 
         */
        public Builder securityPolicyName(String securityPolicyName) {
            return securityPolicyName(Output.of(securityPolicyName));
        }

        /**
         * @param structuredLogDestinations A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
         * 
         * @return builder
         * 
         */
        public Builder structuredLogDestinations(@Nullable Output<List<String>> structuredLogDestinations) {
            $.structuredLogDestinations = structuredLogDestinations;
            return this;
        }

        /**
         * @param structuredLogDestinations A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
         * 
         * @return builder
         * 
         */
        public Builder structuredLogDestinations(List<String> structuredLogDestinations) {
            return structuredLogDestinations(Output.of(structuredLogDestinations));
        }

        /**
         * @param structuredLogDestinations A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
         * 
         * @return builder
         * 
         */
        public Builder structuredLogDestinations(String... structuredLogDestinations) {
            return structuredLogDestinations(List.of(structuredLogDestinations));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param url URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
         * 
         * @return builder
         * 
         */
        public Builder url(@Nullable Output<String> url) {
            $.url = url;
            return this;
        }

        /**
         * @param url URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
         * 
         * @return builder
         * 
         */
        public Builder url(String url) {
            return url(Output.of(url));
        }

        /**
         * @param workflowDetails Specifies the workflow details. See Workflow Details below.
         * 
         * @return builder
         * 
         */
        public Builder workflowDetails(@Nullable Output<ServerWorkflowDetailsArgs> workflowDetails) {
            $.workflowDetails = workflowDetails;
            return this;
        }

        /**
         * @param workflowDetails Specifies the workflow details. See Workflow Details below.
         * 
         * @return builder
         * 
         */
        public Builder workflowDetails(ServerWorkflowDetailsArgs workflowDetails) {
            return workflowDetails(Output.of(workflowDetails));
        }

        public ServerState build() {
            return $;
        }
    }

}
